@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.NamespaceJunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A namespace junction.
 * @property namespacePath Namespace path on a cache for a Storage Target.
 * @property nfsAccessPolicy Name of the access policy applied to this junction.
 * @property nfsExport NFS export where targetPath exists.
 * @property targetPath Path in Storage Target to which namespacePath points.
 */
public data class NamespaceJunctionArgs(
    public val namespacePath: Output<String>? = null,
    public val nfsAccessPolicy: Output<String>? = null,
    public val nfsExport: Output<String>? = null,
    public val targetPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.NamespaceJunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.NamespaceJunctionArgs =
        com.pulumi.azurenative.storagecache.inputs.NamespaceJunctionArgs.builder()
            .namespacePath(namespacePath?.applyValue({ args0 -> args0 }))
            .nfsAccessPolicy(nfsAccessPolicy?.applyValue({ args0 -> args0 }))
            .nfsExport(nfsExport?.applyValue({ args0 -> args0 }))
            .targetPath(targetPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceJunctionArgs].
 */
@PulumiTagMarker
public class NamespaceJunctionArgsBuilder internal constructor() {
    private var namespacePath: Output<String>? = null

    private var nfsAccessPolicy: Output<String>? = null

    private var nfsExport: Output<String>? = null

    private var targetPath: Output<String>? = null

    /**
     * @param value Namespace path on a cache for a Storage Target.
     */
    @JvmName("nyxoaxkkqqcvwyta")
    public suspend fun namespacePath(`value`: Output<String>) {
        this.namespacePath = value
    }

    /**
     * @param value Name of the access policy applied to this junction.
     */
    @JvmName("swarurubtsawconk")
    public suspend fun nfsAccessPolicy(`value`: Output<String>) {
        this.nfsAccessPolicy = value
    }

    /**
     * @param value NFS export where targetPath exists.
     */
    @JvmName("abkgqojtktsimadv")
    public suspend fun nfsExport(`value`: Output<String>) {
        this.nfsExport = value
    }

    /**
     * @param value Path in Storage Target to which namespacePath points.
     */
    @JvmName("qelasjowckydkpbj")
    public suspend fun targetPath(`value`: Output<String>) {
        this.targetPath = value
    }

    /**
     * @param value Namespace path on a cache for a Storage Target.
     */
    @JvmName("udjwxbjgjktouglr")
    public suspend fun namespacePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespacePath = mapped
    }

    /**
     * @param value Name of the access policy applied to this junction.
     */
    @JvmName("fvrandpbdhfhixcs")
    public suspend fun nfsAccessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsAccessPolicy = mapped
    }

    /**
     * @param value NFS export where targetPath exists.
     */
    @JvmName("stjxvatmdagvjmbr")
    public suspend fun nfsExport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsExport = mapped
    }

    /**
     * @param value Path in Storage Target to which namespacePath points.
     */
    @JvmName("qsibabrabydcyilm")
    public suspend fun targetPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPath = mapped
    }

    internal fun build(): NamespaceJunctionArgs = NamespaceJunctionArgs(
        namespacePath = namespacePath,
        nfsAccessPolicy = nfsAccessPolicy,
        nfsExport = nfsExport,
        targetPath = targetPath,
    )
}
