@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the AML file system archive
 * @property filesystemPath Lustre file system path to archive relative to the file system root.  Specify '/' to archive all modified data.
 * @property status The status of the archive
 */
public data class AmlFilesystemArchiveResponse(
    public val filesystemPath: String,
    public val status: AmlFilesystemArchiveResponseStatus,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemArchiveResponse):
            AmlFilesystemArchiveResponse = AmlFilesystemArchiveResponse(
            filesystemPath = javaType.filesystemPath(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemArchiveResponseStatus.Companion.toKotlin(args0)
            }),
        )
    }
}
