@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AML file system HSM settings.
 * @property container Resource ID of storage container used for hydrating the namespace and archiving from the namespace. The resource provider must have permission to create SAS tokens on the storage account.
 * @property importPrefix Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace.
 * @property loggingContainer Resource ID of storage container used for logging events and errors.  Must be a separate container in the same storage account as the hydration and archive container. The resource provider must have permission to create SAS tokens on the storage account.
 */
public data class AmlFilesystemHsmSettingsResponse(
    public val container: String,
    public val importPrefix: String? = null,
    public val loggingContainer: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemHsmSettingsResponse):
            AmlFilesystemHsmSettingsResponse = AmlFilesystemHsmSettingsResponse(
            container = javaType.container(),
            importPrefix = javaType.importPrefix().map({ args0 -> args0 }).orElse(null),
            loggingContainer = javaType.loggingContainer(),
        )
    }
}
