@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Cache identity properties.
 * @property principalId The principal ID for the system-assigned identity of the cache.
 * @property tenantId The tenant ID associated with the cache.
 * @property type The type of identity used for the cache
 * @property userAssignedIdentities A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
 */
public data class CacheIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, CacheIdentityResponseUserAssignedIdentities>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheIdentityResponse):
            CacheIdentityResponse = CacheIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.storagecache.kotlin.outputs.CacheIdentityResponseUserAssignedIdentities.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
