@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a reference to key vault key.
 * @property keyUrl The URL referencing a key encryption key in key vault.
 * @property sourceVault Describes a resource Id to source key vault.
 */
public data class KeyVaultKeyReferenceResponse(
    public val keyUrl: String,
    public val sourceVault: KeyVaultKeyReferenceResponseSourceVault,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.KeyVaultKeyReferenceResponse):
            KeyVaultKeyReferenceResponse = KeyVaultKeyReferenceResponse(
            keyUrl = javaType.keyUrl(),
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.KeyVaultKeyReferenceResponseSourceVault.Companion.toKotlin(args0)
            }),
        )
    }
}
