@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Storage Target space allocation properties.
 * @property allocationPercentage The percentage of cache space allocated for this storage target
 * @property name Name of the storage target.
 */
public data class StorageTargetSpaceAllocationResponse(
    public val allocationPercentage: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.StorageTargetSpaceAllocationResponse):
            StorageTargetSpaceAllocationResponse = StorageTargetSpaceAllocationResponse(
            allocationPercentage = javaType.allocationPercentage().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
