@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.JobDefinitionArgs.builder
import com.pulumi.azurenative.storagemover.kotlin.enums.CopyMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Job Definition resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### JobDefinitions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobDefinition = new AzureNative.StorageMover.JobDefinition("jobDefinition", new()
 *     {
 *         AgentName = "migration-agent",
 *         CopyMode = "Additive",
 *         Description = "Example Job Definition Description",
 *         JobDefinitionName = "examples-jobDefinitionName",
 *         ProjectName = "examples-projectName",
 *         ResourceGroupName = "examples-rg",
 *         SourceName = "examples-sourceEndpointName",
 *         SourceSubpath = "/",
 *         StorageMoverName = "examples-storageMoverName",
 *         TargetName = "examples-targetEndpointName",
 *         TargetSubpath = "/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewJobDefinition(ctx, "jobDefinition", &storagemover.JobDefinitionArgs{
 * 			AgentName:         pulumi.String("migration-agent"),
 * 			CopyMode:          pulumi.String("Additive"),
 * 			Description:       pulumi.String("Example Job Definition Description"),
 * 			JobDefinitionName: pulumi.String("examples-jobDefinitionName"),
 * 			ProjectName:       pulumi.String("examples-projectName"),
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			SourceName:        pulumi.String("examples-sourceEndpointName"),
 * 			SourceSubpath:     pulumi.String("/"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 			TargetName:        pulumi.String("examples-targetEndpointName"),
 * 			TargetSubpath:     pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.JobDefinition;
 * import com.pulumi.azurenative.storagemover.JobDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobDefinition = new JobDefinition("jobDefinition", JobDefinitionArgs.builder()
 *             .agentName("migration-agent")
 *             .copyMode("Additive")
 *             .description("Example Job Definition Description")
 *             .jobDefinitionName("examples-jobDefinitionName")
 *             .projectName("examples-projectName")
 *             .resourceGroupName("examples-rg")
 *             .sourceName("examples-sourceEndpointName")
 *             .sourceSubpath("/")
 *             .storageMoverName("examples-storageMoverName")
 *             .targetName("examples-targetEndpointName")
 *             .targetSubpath("/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:JobDefinition examples-jobDefinitionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/projects/{projectName}/jobDefinitions/{jobDefinitionName}
 * ```
 * @property agentName Name of the Agent to assign for new Job Runs of this Job Definition.
 * @property copyMode Strategy to use for copy.
 * @property description A description for the Job Definition.
 * @property jobDefinitionName The name of the Job Definition resource.
 * @property projectName The name of the Project resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceName The name of the source Endpoint.
 * @property sourceSubpath The subpath to use when reading from the source Endpoint.
 * @property storageMoverName The name of the Storage Mover resource.
 * @property targetName The name of the target Endpoint.
 * @property targetSubpath The subpath to use when writing to the target Endpoint.
 */
public data class JobDefinitionArgs(
    public val agentName: Output<String>? = null,
    public val copyMode: Output<Either<String, CopyMode>>? = null,
    public val description: Output<String>? = null,
    public val jobDefinitionName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceName: Output<String>? = null,
    public val sourceSubpath: Output<String>? = null,
    public val storageMoverName: Output<String>? = null,
    public val targetName: Output<String>? = null,
    public val targetSubpath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.JobDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.JobDefinitionArgs =
        com.pulumi.azurenative.storagemover.JobDefinitionArgs.builder()
            .agentName(agentName?.applyValue({ args0 -> args0 }))
            .copyMode(
                copyMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .jobDefinitionName(jobDefinitionName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceName(sourceName?.applyValue({ args0 -> args0 }))
            .sourceSubpath(sourceSubpath?.applyValue({ args0 -> args0 }))
            .storageMoverName(storageMoverName?.applyValue({ args0 -> args0 }))
            .targetName(targetName?.applyValue({ args0 -> args0 }))
            .targetSubpath(targetSubpath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionArgs].
 */
@PulumiTagMarker
public class JobDefinitionArgsBuilder internal constructor() {
    private var agentName: Output<String>? = null

    private var copyMode: Output<Either<String, CopyMode>>? = null

    private var description: Output<String>? = null

    private var jobDefinitionName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceName: Output<String>? = null

    private var sourceSubpath: Output<String>? = null

    private var storageMoverName: Output<String>? = null

    private var targetName: Output<String>? = null

    private var targetSubpath: Output<String>? = null

    /**
     * @param value Name of the Agent to assign for new Job Runs of this Job Definition.
     */
    @JvmName("gpklpnjovnbsblmk")
    public suspend fun agentName(`value`: Output<String>) {
        this.agentName = value
    }

    /**
     * @param value Strategy to use for copy.
     */
    @JvmName("drasritywcmfksdm")
    public suspend fun copyMode(`value`: Output<Either<String, CopyMode>>) {
        this.copyMode = value
    }

    /**
     * @param value A description for the Job Definition.
     */
    @JvmName("wuombxjtcspecwvn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Job Definition resource.
     */
    @JvmName("gsgybsaydvqlosap")
    public suspend fun jobDefinitionName(`value`: Output<String>) {
        this.jobDefinitionName = value
    }

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("ydlkcldhapvvwftr")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jpauqaihdxtoppup")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the source Endpoint.
     */
    @JvmName("itucpspvugnwbfqy")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value The subpath to use when reading from the source Endpoint.
     */
    @JvmName("jiaocddmypwjnrma")
    public suspend fun sourceSubpath(`value`: Output<String>) {
        this.sourceSubpath = value
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("sfdgunomtrunnlng")
    public suspend fun storageMoverName(`value`: Output<String>) {
        this.storageMoverName = value
    }

    /**
     * @param value The name of the target Endpoint.
     */
    @JvmName("ahecwpdnmrsgmffh")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value The subpath to use when writing to the target Endpoint.
     */
    @JvmName("idgngnxjsjxsqhjl")
    public suspend fun targetSubpath(`value`: Output<String>) {
        this.targetSubpath = value
    }

    /**
     * @param value Name of the Agent to assign for new Job Runs of this Job Definition.
     */
    @JvmName("mvpkaxoxiixakqrr")
    public suspend fun agentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentName = mapped
    }

    /**
     * @param value Strategy to use for copy.
     */
    @JvmName("xiwgekjogmjilboi")
    public suspend fun copyMode(`value`: Either<String, CopyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyMode = mapped
    }

    /**
     * @param value Strategy to use for copy.
     */
    @JvmName("npgixfcwwfejclxo")
    public fun copyMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CopyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.copyMode = mapped
    }

    /**
     * @param value Strategy to use for copy.
     */
    @JvmName("qdspuciysdxjavgt")
    public fun copyMode(`value`: CopyMode) {
        val toBeMapped = Either.ofRight<String, CopyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.copyMode = mapped
    }

    /**
     * @param value A description for the Job Definition.
     */
    @JvmName("mploirekqtwluubn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Job Definition resource.
     */
    @JvmName("judljwcbreaeuyuv")
    public suspend fun jobDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobDefinitionName = mapped
    }

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("yebxokdsxxljidso")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("whagosdpaeebiwrt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the source Endpoint.
     */
    @JvmName("qpxdhbqllwwxgppc")
    public suspend fun sourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value The subpath to use when reading from the source Endpoint.
     */
    @JvmName("kebovoriyrhailsr")
    public suspend fun sourceSubpath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSubpath = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("ghqfgdwranwqeipq")
    public suspend fun storageMoverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMoverName = mapped
    }

    /**
     * @param value The name of the target Endpoint.
     */
    @JvmName("vkywvetspxvqcbxx")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value The subpath to use when writing to the target Endpoint.
     */
    @JvmName("ewearmtsdfyhanqq")
    public suspend fun targetSubpath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSubpath = mapped
    }

    internal fun build(): JobDefinitionArgs = JobDefinitionArgs(
        agentName = agentName,
        copyMode = copyMode,
        description = description,
        jobDefinitionName = jobDefinitionName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        sourceName = sourceName,
        sourceSubpath = sourceSubpath,
        storageMoverName = storageMoverName,
        targetName = targetName,
        targetSubpath = targetSubpath,
    )
}
