@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The name of the Endpoint resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class GetEndpointPlainArgs(
    public val endpointName: String,
    public val resourceGroupName: String,
    public val storageMoverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.GetEndpointPlainArgs =
        com.pulumi.azurenative.storagemover.inputs.GetEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageMoverName(storageMoverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var resourceGroupName: String? = null

    private var storageMoverName: String? = null

    /**
     * @param value The name of the Endpoint resource.
     */
    @JvmName("poburcbpyoufbvtv")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hmxqblnfrmkhsqmb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("memreosrpwrippgx")
    public suspend fun storageMoverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageMoverName = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageMoverName = storageMoverName ?: throw PulumiNullFieldException("storageMoverName"),
    )
}
