@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Job Definition resource.
 * @property agentName Name of the Agent to assign for new Job Runs of this Job Definition.
 * @property agentResourceId Fully qualified resource id of the Agent to assign for new Job Runs of this Job Definition.
 * @property copyMode Strategy to use for copy.
 * @property description A description for the Job Definition.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property latestJobRunName The name of the Job Run in a non-terminal state, if exists.
 * @property latestJobRunResourceId The fully qualified resource ID of the Job Run in a non-terminal state, if exists.
 * @property latestJobRunStatus The current status of the Job Run in a non-terminal state, if exists.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of this resource.
 * @property sourceName The name of the source Endpoint.
 * @property sourceResourceId Fully qualified resource ID of the source Endpoint.
 * @property sourceSubpath The subpath to use when reading from the source Endpoint.
 * @property systemData Resource system metadata.
 * @property targetName The name of the target Endpoint.
 * @property targetResourceId Fully qualified resource ID of the target Endpoint.
 * @property targetSubpath The subpath to use when writing to the target Endpoint.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetJobDefinitionResult(
    public val agentName: String? = null,
    public val agentResourceId: String,
    public val copyMode: String,
    public val description: String? = null,
    public val id: String,
    public val latestJobRunName: String,
    public val latestJobRunResourceId: String,
    public val latestJobRunStatus: String,
    public val name: String,
    public val provisioningState: String,
    public val sourceName: String,
    public val sourceResourceId: String,
    public val sourceSubpath: String? = null,
    public val systemData: SystemDataResponse,
    public val targetName: String,
    public val targetResourceId: String,
    public val targetSubpath: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagemover.outputs.GetJobDefinitionResult):
            GetJobDefinitionResult = GetJobDefinitionResult(
            agentName = javaType.agentName().map({ args0 -> args0 }).orElse(null),
            agentResourceId = javaType.agentResourceId(),
            copyMode = javaType.copyMode(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            latestJobRunName = javaType.latestJobRunName(),
            latestJobRunResourceId = javaType.latestJobRunResourceId(),
            latestJobRunStatus = javaType.latestJobRunStatus(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceName = javaType.sourceName(),
            sourceResourceId = javaType.sourceResourceId(),
            sourceSubpath = javaType.sourceSubpath().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetName = javaType.targetName(),
            targetResourceId = javaType.targetResourceId(),
            targetSubpath = javaType.targetSubpath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
