@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin

import com.pulumi.azurenative.storagepool.DiskPoolArgs.builder
import com.pulumi.azurenative.storagepool.kotlin.inputs.DiskArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.DiskArgsBuilder
import com.pulumi.azurenative.storagepool.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Response for Disk Pool request.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-03-15-preview.
 * Other available API versions: 2020-03-15-preview.
 * ## Example Usage
 * ### Create or Update Disk pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskPool = new AzureNative.StoragePool.DiskPool("diskPool", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "1",
 *         },
 *         DiskPoolName = "myDiskPool",
 *         Disks = new[]
 *         {
 *             new AzureNative.StoragePool.Inputs.DiskArgs
 *             {
 *                 Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0",
 *             },
 *             new AzureNative.StoragePool.Inputs.DiskArgs
 *             {
 *                 Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1",
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.StoragePool.Inputs.SkuArgs
 *         {
 *             Name = "Basic_V1",
 *             Tier = "Basic",
 *         },
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagepool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagepool.NewDiskPool(ctx, "diskPool", &storagepool.DiskPoolArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 			DiskPoolName: pulumi.String("myDiskPool"),
 * 			Disks: []storagepool.DiskArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &storagepool.SkuArgs{
 * 				Name: pulumi.String("Basic_V1"),
 * 				Tier: pulumi.String("Basic"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagepool.DiskPool;
 * import com.pulumi.azurenative.storagepool.DiskPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskPool = new DiskPool("diskPool", DiskPoolArgs.builder()
 *             .availabilityZones("1")
 *             .diskPoolName("myDiskPool")
 *             .disks(
 *                 Map.of("id", "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0"),
 *                 Map.of("id", "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1"))
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic_V1"),
 *                 Map.entry("tier", "Basic")
 *             ))
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagepool:DiskPool myDiskPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StoragePool/diskPools/{diskPoolName}
 * ```
 * @property additionalCapabilities List of additional capabilities for a Disk Pool.
 * @property availabilityZones Logical zone for Disk Pool resource; example: ["1"].
 * @property diskPoolName The name of the Disk Pool.
 * @property disks List of Azure Managed Disks to attach to a Disk Pool.
 * @property location The geo-location where the resource lives.
 * @property managedBy Azure resource id. Indicates if this resource is managed by another Azure resource.
 * @property managedByExtended List of Azure resource ids that manage this resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Determines the SKU of the Disk Pool
 * @property subnetId Azure Resource ID of a Subnet for the Disk Pool.
 * @property tags Resource tags.
 */
public data class DiskPoolArgs(
    public val additionalCapabilities: Output<List<String>>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val diskPoolName: Output<String>? = null,
    public val disks: Output<List<DiskArgs>>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val managedByExtended: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.DiskPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.DiskPoolArgs =
        com.pulumi.azurenative.storagepool.DiskPoolArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .diskPoolName(diskPoolName?.applyValue({ args0 -> args0 }))
            .disks(disks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .managedByExtended(managedByExtended?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiskPoolArgs].
 */
@PulumiTagMarker
public class DiskPoolArgsBuilder internal constructor() {
    private var additionalCapabilities: Output<List<String>>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var diskPoolName: Output<String>? = null

    private var disks: Output<List<DiskArgs>>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var managedByExtended: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of additional capabilities for a Disk Pool.
     */
    @JvmName("kalpejuanvybybjl")
    public suspend fun additionalCapabilities(`value`: Output<List<String>>) {
        this.additionalCapabilities = value
    }

    @JvmName("kdpdmnvnrqmoxvod")
    public suspend fun additionalCapabilities(vararg values: Output<String>) {
        this.additionalCapabilities = Output.all(values.asList())
    }

    /**
     * @param values List of additional capabilities for a Disk Pool.
     */
    @JvmName("ewiydolxjetinvlp")
    public suspend fun additionalCapabilities(values: List<Output<String>>) {
        this.additionalCapabilities = Output.all(values)
    }

    /**
     * @param value Logical zone for Disk Pool resource; example: ["1"].
     */
    @JvmName("tmywurrmjwkohrue")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("xandjxqcblboeimj")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values Logical zone for Disk Pool resource; example: ["1"].
     */
    @JvmName("pkwmudamdhvukhdy")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("hqlurdtldwxsmlnw")
    public suspend fun diskPoolName(`value`: Output<String>) {
        this.diskPoolName = value
    }

    /**
     * @param value List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("mahlqspfcveaefpo")
    public suspend fun disks(`value`: Output<List<DiskArgs>>) {
        this.disks = value
    }

    @JvmName("iqhrwscfpshctjxd")
    public suspend fun disks(vararg values: Output<DiskArgs>) {
        this.disks = Output.all(values.asList())
    }

    /**
     * @param values List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("eegmcswrakiyecmg")
    public suspend fun disks(values: List<Output<DiskArgs>>) {
        this.disks = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("hhyqxqwelsvcolvt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    @JvmName("bjxjemlqdriaukjp")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value List of Azure resource ids that manage this resource.
     */
    @JvmName("porwbxradkhshpta")
    public suspend fun managedByExtended(`value`: Output<List<String>>) {
        this.managedByExtended = value
    }

    @JvmName("popxxjojcanhfqna")
    public suspend fun managedByExtended(vararg values: Output<String>) {
        this.managedByExtended = Output.all(values.asList())
    }

    /**
     * @param values List of Azure resource ids that manage this resource.
     */
    @JvmName("nixytqukfuqyvmti")
    public suspend fun managedByExtended(values: List<Output<String>>) {
        this.managedByExtended = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjawkvolnsqanjhx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Determines the SKU of the Disk Pool
     */
    @JvmName("dgtepdyhhtxavode")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Azure Resource ID of a Subnet for the Disk Pool.
     */
    @JvmName("cgesmnfgcrxmxvsx")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xccpoqdwlmqijprm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of additional capabilities for a Disk Pool.
     */
    @JvmName("ilnuqqpkhclihcmx")
    public suspend fun additionalCapabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param values List of additional capabilities for a Disk Pool.
     */
    @JvmName("cvpkjmbcadkrrqlp")
    public suspend fun additionalCapabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param value Logical zone for Disk Pool resource; example: ["1"].
     */
    @JvmName("otwjpkatbkofcbnx")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values Logical zone for Disk Pool resource; example: ["1"].
     */
    @JvmName("aecrnmkteilwsiar")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("fkexefytearofpfv")
    public suspend fun diskPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPoolName = mapped
    }

    /**
     * @param value List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("ggtajdchokrwabqc")
    public suspend fun disks(`value`: List<DiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param argument List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("cdhydtnwtjpdinom")
    public suspend fun disks(argument: List<suspend DiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("dmpgbvwsjyukcotb")
    public suspend fun disks(vararg argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("qjmgjirtocgtvepc")
    public suspend fun disks(argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param values List of Azure Managed Disks to attach to a Disk Pool.
     */
    @JvmName("bwguvihtxfutasyx")
    public suspend fun disks(vararg values: DiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("eypwgongkklskndm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    @JvmName("ktvvfqvksmychvrt")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value List of Azure resource ids that manage this resource.
     */
    @JvmName("vhaonsiegjxtnglf")
    public suspend fun managedByExtended(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedByExtended = mapped
    }

    /**
     * @param values List of Azure resource ids that manage this resource.
     */
    @JvmName("xubnvnkrrsgkpvvh")
    public suspend fun managedByExtended(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedByExtended = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvgthecgiwfjaqhs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Determines the SKU of the Disk Pool
     */
    @JvmName("njittmvvatweyule")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Determines the SKU of the Disk Pool
     */
    @JvmName("mlhxhmfvwefrwonr")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Azure Resource ID of a Subnet for the Disk Pool.
     */
    @JvmName("xrqejgnsngbgixjh")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("arwlbelykyjcijfr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("yrkaodccjjhhxron")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiskPoolArgs = DiskPoolArgs(
        additionalCapabilities = additionalCapabilities,
        availabilityZones = availabilityZones,
        diskPoolName = diskPoolName,
        disks = disks,
        location = location,
        managedBy = managedBy,
        managedByExtended = managedByExtended,
        resourceGroupName = resourceGroupName,
        sku = sku,
        subnetId = subnetId,
        tags = tags,
    )
}
