@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.inputs

import com.pulumi.azurenative.storagepool.inputs.DiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Managed Disk to attach to the Disk Pool.
 * @property id Unique Azure Resource ID of the Managed Disk.
 */
public data class DiskArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.inputs.DiskArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.inputs.DiskArgs =
        com.pulumi.azurenative.storagepool.inputs.DiskArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Unique Azure Resource ID of the Managed Disk.
     */
    @JvmName("esrsgscknvcyjpqe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Unique Azure Resource ID of the Managed Disk.
     */
    @JvmName("nttsvihfexscwfto")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
