@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * LUN to expose the Azure Managed Disk.
 * @property lun Specifies the Logical Unit Number of the iSCSI LUN.
 * @property managedDiskAzureResourceId Azure Resource ID of the Managed Disk.
 * @property name User defined name for iSCSI LUN; example: "lun0"
 */
public data class IscsiLunResponse(
    public val lun: Int,
    public val managedDiskAzureResourceId: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagepool.outputs.IscsiLunResponse):
            IscsiLunResponse = IscsiLunResponse(
            lun = javaType.lun(),
            managedDiskAzureResourceId = javaType.managedDiskAzureResourceId(),
            name = javaType.name(),
        )
    }
}
