@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegisteredServer].
 */
@PulumiTagMarker
public class RegisteredServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegisteredServerArgs = RegisteredServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegisteredServerArgsBuilder.() -> Unit) {
        val builder = RegisteredServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegisteredServer {
        val builtJavaResource =
            com.pulumi.azurenative.storagesync.RegisteredServer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegisteredServer(builtJavaResource)
    }
}

/**
 * Registered Server resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2022-09-01.
 * ## Example Usage
 * ### RegisteredServers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredServer = new AzureNative.StorageSync.RegisteredServer("registeredServer", new()
 *     {
 *         AgentVersion = "1.0.277.0",
 *         FriendlyName = "afscv-2304-139",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         ServerCertificate = "MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM=",
 *         ServerId = "080d4133-bdb5-40a0-96a0-71a6057bfe9a",
 *         ServerOSVersion = "10.0.14393.0",
 *         ServerRole = "Standalone",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewRegisteredServer(ctx, "registeredServer", &storagesync.RegisteredServerArgs{
 * 			AgentVersion:           pulumi.String("1.0.277.0"),
 * 			FriendlyName:           pulumi.String("afscv-2304-139"),
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			ServerCertificate:      pulumi.String("MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM="),
 * 			ServerId:               pulumi.String("080d4133-bdb5-40a0-96a0-71a6057bfe9a"),
 * 			ServerOSVersion:        pulumi.String("10.0.14393.0"),
 * 			ServerRole:             pulumi.String("Standalone"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.RegisteredServer;
 * import com.pulumi.azurenative.storagesync.RegisteredServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredServer = new RegisteredServer("registeredServer", RegisteredServerArgs.builder()
 *             .agentVersion("1.0.277.0")
 *             .friendlyName("afscv-2304-139")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .serverCertificate("MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM=")
 *             .serverId("080d4133-bdb5-40a0-96a0-71a6057bfe9a")
 *             .serverOSVersion("10.0.14393.0")
 *             .serverRole("Standalone")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:RegisteredServer ankushb-prod3.redmond.corp.microsoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/registeredServers/{serverId}
 * ```
 */
public class RegisteredServer internal constructor(
    override val javaResource: com.pulumi.azurenative.storagesync.RegisteredServer,
) : KotlinCustomResource(javaResource, RegisteredServerMapper) {
    /**
     * Registered Server Agent Version
     */
    public val agentVersion: Output<String>?
        get() = javaResource.agentVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server Agent Version Expiration Date
     */
    public val agentVersionExpirationDate: Output<String>
        get() = javaResource.agentVersionExpirationDate().applyValue({ args0 -> args0 })

    /**
     * Registered Server Agent Version Status
     */
    public val agentVersionStatus: Output<String>
        get() = javaResource.agentVersionStatus().applyValue({ args0 -> args0 })

    /**
     * Registered Server clusterId
     */
    public val clusterId: Output<String>?
        get() = javaResource.clusterId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Registered Server clusterName
     */
    public val clusterName: Output<String>?
        get() = javaResource.clusterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource discoveryEndpointUri
     */
    public val discoveryEndpointUri: Output<String>?
        get() = javaResource.discoveryEndpointUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Friendly Name
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server last heart beat
     */
    public val lastHeartBeat: Output<String>?
        get() = javaResource.lastHeartBeat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Last Operation Name
     */
    public val lastOperationName: Output<String>?
        get() = javaResource.lastOperationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server lastWorkflowId
     */
    public val lastWorkflowId: Output<String>?
        get() = javaResource.lastWorkflowId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Management Endpoint Uri
     */
    public val managementEndpointUri: Output<String>?
        get() = javaResource.managementEndpointUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Monitoring Configuration
     */
    public val monitoringConfiguration: Output<String>?
        get() = javaResource.monitoringConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Telemetry Endpoint Uri
     */
    public val monitoringEndpointUri: Output<String>?
        get() = javaResource.monitoringEndpointUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Registered Server Provisioning State
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Location
     */
    public val resourceLocation: Output<String>?
        get() = javaResource.resourceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server Certificate
     */
    public val serverCertificate: Output<String>?
        get() = javaResource.serverCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server serverId
     */
    public val serverId: Output<String>?
        get() = javaResource.serverId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Registered Server Management Error Code
     */
    public val serverManagementErrorCode: Output<Int>?
        get() = javaResource.serverManagementErrorCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server name
     */
    public val serverName: Output<String>
        get() = javaResource.serverName().applyValue({ args0 -> args0 })

    /**
     * Registered Server OS Version
     */
    public val serverOSVersion: Output<String>?
        get() = javaResource.serverOSVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server serverRole
     */
    public val serverRole: Output<String>?
        get() = javaResource.serverRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Service Location
     */
    public val serviceLocation: Output<String>?
        get() = javaResource.serviceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Registered Server storageSyncServiceUid
     */
    public val storageSyncServiceUid: Output<String>?
        get() = javaResource.storageSyncServiceUid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegisteredServerMapper : ResourceMapper<RegisteredServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagesync.RegisteredServer::class == javaResource::class

    override fun map(javaResource: Resource): RegisteredServer = RegisteredServer(
        javaResource as
            com.pulumi.azurenative.storagesync.RegisteredServer,
    )
}

/**
 * @see [RegisteredServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegisteredServer].
 */
public suspend fun registeredServer(
    name: String,
    block: suspend RegisteredServerResourceBuilder.() -> Unit,
): RegisteredServer {
    val builder = RegisteredServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegisteredServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registeredServer(name: String): RegisteredServer {
    val builder = RegisteredServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
