@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.RegisteredServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registered Server resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2022-09-01.
 * ## Example Usage
 * ### RegisteredServers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredServer = new AzureNative.StorageSync.RegisteredServer("registeredServer", new()
 *     {
 *         AgentVersion = "1.0.277.0",
 *         FriendlyName = "afscv-2304-139",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         ServerCertificate = "MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM=",
 *         ServerId = "080d4133-bdb5-40a0-96a0-71a6057bfe9a",
 *         ServerOSVersion = "10.0.14393.0",
 *         ServerRole = "Standalone",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewRegisteredServer(ctx, "registeredServer", &storagesync.RegisteredServerArgs{
 * 			AgentVersion:           pulumi.String("1.0.277.0"),
 * 			FriendlyName:           pulumi.String("afscv-2304-139"),
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			ServerCertificate:      pulumi.String("MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM="),
 * 			ServerId:               pulumi.String("080d4133-bdb5-40a0-96a0-71a6057bfe9a"),
 * 			ServerOSVersion:        pulumi.String("10.0.14393.0"),
 * 			ServerRole:             pulumi.String("Standalone"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.RegisteredServer;
 * import com.pulumi.azurenative.storagesync.RegisteredServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredServer = new RegisteredServer("registeredServer", RegisteredServerArgs.builder()
 *             .agentVersion("1.0.277.0")
 *             .friendlyName("afscv-2304-139")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .serverCertificate("MIIDFjCCAf6gAwIBAgIQQS+DS8uhc4VNzUkTw7wbRjANBgkqhkiG9w0BAQ0FADAzMTEwLwYDVQQDEyhhbmt1c2hiLXByb2QzLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tMB4XDTE3MDgwMzE3MDQyNFoXDTE4MDgwNDE3MDQyNFowMzExMC8GA1UEAxMoYW5rdXNoYi1wcm9kMy5yZWRtb25kLmNvcnAubWljcm9zb2Z0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALDRvV4gmsIy6jGDPiHsXmvgVP749NNP7DopdlbHaNhjFmYINHl0uWylyaZmgJrROt2mnxN/zEyJtGnqYHlzUr4xvGq/qV5pqgdB9tag/sw9i22gfe9PRZ0FmSOZnXMbLYgLiDFqLtut5gHcOuWMj03YnkfoBEKlFBxWbagvW2yxz/Sxi9OVSJOKCaXra0RpcIHrO/KFl6ho2eE1/7Ykmfa8hZvSdoPd5gHdLiQcMB/pxq+mWp1fI6c8vFZoDu7Atn+NXTzYPKUxKzaisF12TsaKpohUsJpbB3Wocb0F5frn614D2pg14ERB5otjAMWw1m65csQWPI6dP8KIYe0+QPkCAwEAAaMmMCQwIgYDVR0lAQH/BBgwFgYIKwYBBQUHAwIGCisGAQQBgjcKAwwwDQYJKoZIhvcNAQENBQADggEBAA4RhVIBkw34M1RwakJgHvtjsOFxF1tVQA941NtLokx1l2Z8+GFQkcG4xpZSt+UN6wLerdCbnNhtkCErWUDeaT0jxk4g71Ofex7iM04crT4iHJr8mi96/XnhnkTUs+GDk12VgdeeNEczMZz+8Mxw9dJ5NCnYgTwO0SzGlclRsDvjzkLo8rh2ZG6n/jKrEyNXXo+hOqhupij0QbRP2Tvexdfw201kgN1jdZify8XzJ8Oi0bTS0KpJf2pNPOlooK2bjMUei9ANtEdXwwfVZGWvVh6tJjdv6k14wWWJ1L7zhA1IIVb1J+sQUzJji5iX0DrezjTz1Fg+gAzITaA/WsuujlM=")
 *             .serverId("080d4133-bdb5-40a0-96a0-71a6057bfe9a")
 *             .serverOSVersion("10.0.14393.0")
 *             .serverRole("Standalone")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:RegisteredServer ankushb-prod3.redmond.corp.microsoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/registeredServers/{serverId}
 * ```
 * @property agentVersion Registered Server Agent Version
 * @property clusterId Registered Server clusterId
 * @property clusterName Registered Server clusterName
 * @property friendlyName Friendly Name
 * @property lastHeartBeat Registered Server last heart beat
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverCertificate Registered Server Certificate
 * @property serverId Registered Server serverId
 * @property serverOSVersion Registered Server OS Version
 * @property serverRole Registered Server serverRole
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 */
public data class RegisteredServerArgs(
    public val agentVersion: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val lastHeartBeat: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverCertificate: Output<String>? = null,
    public val serverId: Output<String>? = null,
    public val serverOSVersion: Output<String>? = null,
    public val serverRole: Output<String>? = null,
    public val storageSyncServiceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.RegisteredServerArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.RegisteredServerArgs =
        com.pulumi.azurenative.storagesync.RegisteredServerArgs.builder()
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .lastHeartBeat(lastHeartBeat?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverCertificate(serverCertificate?.applyValue({ args0 -> args0 }))
            .serverId(serverId?.applyValue({ args0 -> args0 }))
            .serverOSVersion(serverOSVersion?.applyValue({ args0 -> args0 }))
            .serverRole(serverRole?.applyValue({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredServerArgs].
 */
@PulumiTagMarker
public class RegisteredServerArgsBuilder internal constructor() {
    private var agentVersion: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var lastHeartBeat: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverCertificate: Output<String>? = null

    private var serverId: Output<String>? = null

    private var serverOSVersion: Output<String>? = null

    private var serverRole: Output<String>? = null

    private var storageSyncServiceName: Output<String>? = null

    /**
     * @param value Registered Server Agent Version
     */
    @JvmName("ujyjdxfxmpgkvwns")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value Registered Server clusterId
     */
    @JvmName("yphgryumemlgffic")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Registered Server clusterName
     */
    @JvmName("hxtkjavnmxeaawxm")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("kcyotjkijbtdokco")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Registered Server last heart beat
     */
    @JvmName("eypdufhkrmqxtcvm")
    public suspend fun lastHeartBeat(`value`: Output<String>) {
        this.lastHeartBeat = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ombrrvhmvhfoshjp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Registered Server Certificate
     */
    @JvmName("hfqmcxkqeqrktgth")
    public suspend fun serverCertificate(`value`: Output<String>) {
        this.serverCertificate = value
    }

    /**
     * @param value Registered Server serverId
     */
    @JvmName("nhtgiadfkdeeibhn")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value Registered Server OS Version
     */
    @JvmName("ppodnnrvgmmtgsra")
    public suspend fun serverOSVersion(`value`: Output<String>) {
        this.serverOSVersion = value
    }

    /**
     * @param value Registered Server serverRole
     */
    @JvmName("proswsdcnkwcxyqb")
    public suspend fun serverRole(`value`: Output<String>) {
        this.serverRole = value
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("xkgmbkfhsptfwcbe")
    public suspend fun storageSyncServiceName(`value`: Output<String>) {
        this.storageSyncServiceName = value
    }

    /**
     * @param value Registered Server Agent Version
     */
    @JvmName("yaoepaqninvubipt")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value Registered Server clusterId
     */
    @JvmName("ojanaqjjtacwvmoy")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Registered Server clusterName
     */
    @JvmName("mskksocdxckswqne")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("sjlandguqtwtpopv")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Registered Server last heart beat
     */
    @JvmName("qypmcnoepjqtulso")
    public suspend fun lastHeartBeat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastHeartBeat = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mxrtodcxcvawxcsh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Registered Server Certificate
     */
    @JvmName("gyfbqvobampgknks")
    public suspend fun serverCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificate = mapped
    }

    /**
     * @param value Registered Server serverId
     */
    @JvmName("cgteaevfnhrswsdf")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value Registered Server OS Version
     */
    @JvmName("nvpnplionmtbahku")
    public suspend fun serverOSVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverOSVersion = mapped
    }

    /**
     * @param value Registered Server serverRole
     */
    @JvmName("vhyxkugtfafaihda")
    public suspend fun serverRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverRole = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("tpdekxshhtmmbkdk")
    public suspend fun storageSyncServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSyncServiceName = mapped
    }

    internal fun build(): RegisteredServerArgs = RegisteredServerArgs(
        agentVersion = agentVersion,
        clusterId = clusterId,
        clusterName = clusterName,
        friendlyName = friendlyName,
        lastHeartBeat = lastHeartBeat,
        resourceGroupName = resourceGroupName,
        serverCertificate = serverCertificate,
        serverId = serverId,
        serverOSVersion = serverOSVersion,
        serverRole = serverRole,
        storageSyncServiceName = storageSyncServiceName,
    )
}
