@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.SyncGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sync Group object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2022-09-01.
 * ## Example Usage
 * ### SyncGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.StorageSync.SyncGroup("syncGroup", new()
 *     {
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewSyncGroup(ctx, "syncGroup", &storagesync.SyncGroupArgs{
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:          pulumi.String("SampleSyncGroup_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.SyncGroup;
 * import com.pulumi.azurenative.storagesync.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:SyncGroup SampleSyncGroup_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}
 * ```
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property syncGroupName Name of Sync Group resource.
 */
public data class SyncGroupArgs(
    public val resourceGroupName: Output<String>? = null,
    public val storageSyncServiceName: Output<String>? = null,
    public val syncGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.SyncGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.SyncGroupArgs =
        com.pulumi.azurenative.storagesync.SyncGroupArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName?.applyValue({ args0 -> args0 }))
            .syncGroupName(syncGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncGroupArgs].
 */
@PulumiTagMarker
public class SyncGroupArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var storageSyncServiceName: Output<String>? = null

    private var syncGroupName: Output<String>? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("utabegixlclyioxe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("uynnqfdjwstxlerr")
    public suspend fun storageSyncServiceName(`value`: Output<String>) {
        this.storageSyncServiceName = value
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("idsufvdmlfyqkcre")
    public suspend fun syncGroupName(`value`: Output<String>) {
        this.syncGroupName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ukrxiphuetdlxpma")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("stqclcscaxvgacsr")
    public suspend fun storageSyncServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("ohpxdyqwkerbjlli")
    public suspend fun syncGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncGroupName = mapped
    }

    internal fun build(): SyncGroupArgs = SyncGroupArgs(
        resourceGroupName = resourceGroupName,
        storageSyncServiceName = storageSyncServiceName,
        syncGroupName = syncGroupName,
    )
}
