@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.inputs

import com.pulumi.azurenative.storagesync.inputs.GetRegisteredServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverId GUID identifying the on-premises server.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 */
public data class GetRegisteredServerPlainArgs(
    public val resourceGroupName: String,
    public val serverId: String,
    public val storageSyncServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.inputs.GetRegisteredServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.inputs.GetRegisteredServerPlainArgs =
        com.pulumi.azurenative.storagesync.inputs.GetRegisteredServerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverId(serverId.let({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegisteredServerPlainArgs].
 */
@PulumiTagMarker
public class GetRegisteredServerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverId: String? = null

    private var storageSyncServiceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hmrmwkvyagfasocc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value GUID identifying the on-premises server.
     */
    @JvmName("khaqbprjkksksqsa")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverId = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("fttewwkrbbanxpek")
    public suspend fun storageSyncServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageSyncServiceName = mapped
    }

    internal fun build(): GetRegisteredServerPlainArgs = GetRegisteredServerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
        storageSyncServiceName = storageSyncServiceName ?: throw
            PulumiNullFieldException("storageSyncServiceName"),
    )
}
