@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information regarding the low disk mode state
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property state Low disk mode state
 */
public data class CloudTieringLowDiskModeResponse(
    public val lastUpdatedTimestamp: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringLowDiskModeResponse):
            CloudTieringLowDiskModeResponse = CloudTieringLowDiskModeResponse(
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            state = javaType.state(),
        )
    }
}
