@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Server endpoint cloud tiering status object.
 * @property cachedSizeBytes Cached content size on the server
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property spaceSavingsBytes Count of bytes saved on the server
 * @property spaceSavingsPercent Percentage of cached size over total size
 * @property totalSizeCloudBytes Total size of content in the azure file share
 * @property volumeSizeBytes Volume size
 */
public data class CloudTieringSpaceSavingsResponse(
    public val cachedSizeBytes: Double,
    public val lastUpdatedTimestamp: String,
    public val spaceSavingsBytes: Double,
    public val spaceSavingsPercent: Int,
    public val totalSizeCloudBytes: Double,
    public val volumeSizeBytes: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringSpaceSavingsResponse):
            CloudTieringSpaceSavingsResponse = CloudTieringSpaceSavingsResponse(
            cachedSizeBytes = javaType.cachedSizeBytes(),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            spaceSavingsBytes = javaType.spaceSavingsBytes(),
            spaceSavingsPercent = javaType.spaceSavingsPercent(),
            totalSizeCloudBytes = javaType.totalSizeCloudBytes(),
            volumeSizeBytes = javaType.volumeSizeBytes(),
        )
    }
}
