@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessControlRecord].
 */
@PulumiTagMarker
public class AccessControlRecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessControlRecordArgs = AccessControlRecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessControlRecordArgsBuilder.() -> Unit) {
        val builder = AccessControlRecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessControlRecord {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.AccessControlRecord(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessControlRecord(builtJavaResource)
    }
}

/**
 * The access control record.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### AccessControlRecordsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessControlRecord = new AzureNative.StorSimple.AccessControlRecord("accessControlRecord", new()
 *     {
 *         AccessControlRecordName = "ACRForTest",
 *         InitiatorName = "iqn.2017-06.com.contoso:ForTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewAccessControlRecord(ctx, "accessControlRecord", &storsimple.AccessControlRecordArgs{
 * 			AccessControlRecordName: pulumi.String("ACRForTest"),
 * 			InitiatorName:           pulumi.String("iqn.2017-06.com.contoso:ForTest"),
 * 			ManagerName:             pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:       pulumi.String("ResourceGroupForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.AccessControlRecord;
 * import com.pulumi.azurenative.storsimple.AccessControlRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessControlRecord = new AccessControlRecord("accessControlRecord", AccessControlRecordArgs.builder()
 *             .accessControlRecordName("ACRForTest")
 *             .initiatorName("iqn.2017-06.com.contoso:ForTest")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:AccessControlRecord ACRForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords/{accessControlRecordName}
 * ```
 */
public class AccessControlRecord internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.AccessControlRecord,
) : KotlinCustomResource(javaResource, AccessControlRecordMapper) {
    /**
     * The iSCSI initiator name (IQN).
     */
    public val initiatorName: Output<String>
        get() = javaResource.initiatorName().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The number of volumes using the access control record.
     */
    public val volumeCount: Output<Int>
        get() = javaResource.volumeCount().applyValue({ args0 -> args0 })
}

public object AccessControlRecordMapper : ResourceMapper<AccessControlRecord> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.AccessControlRecord::class == javaResource::class

    override fun map(javaResource: Resource): AccessControlRecord = AccessControlRecord(
        javaResource
            as com.pulumi.azurenative.storsimple.AccessControlRecord,
    )
}

/**
 * @see [AccessControlRecord].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessControlRecord].
 */
public suspend fun accessControlRecord(
    name: String,
    block: suspend AccessControlRecordResourceBuilder.() -> Unit,
): AccessControlRecord {
    val builder = AccessControlRecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessControlRecord].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessControlRecord(name: String): AccessControlRecord {
    val builder = AccessControlRecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
