@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.AccessControlRecordArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The access control record.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### AccessControlRecordsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessControlRecord = new AzureNative.StorSimple.AccessControlRecord("accessControlRecord", new()
 *     {
 *         AccessControlRecordName = "ACRForTest",
 *         InitiatorName = "iqn.2017-06.com.contoso:ForTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewAccessControlRecord(ctx, "accessControlRecord", &storsimple.AccessControlRecordArgs{
 * 			AccessControlRecordName: pulumi.String("ACRForTest"),
 * 			InitiatorName:           pulumi.String("iqn.2017-06.com.contoso:ForTest"),
 * 			ManagerName:             pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:       pulumi.String("ResourceGroupForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.AccessControlRecord;
 * import com.pulumi.azurenative.storsimple.AccessControlRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessControlRecord = new AccessControlRecord("accessControlRecord", AccessControlRecordArgs.builder()
 *             .accessControlRecordName("ACRForTest")
 *             .initiatorName("iqn.2017-06.com.contoso:ForTest")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:AccessControlRecord ACRForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords/{accessControlRecordName}
 * ```
 * @property accessControlRecordName The name of the access control record.
 * @property initiatorName The iSCSI initiator name (IQN).
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class AccessControlRecordArgs(
    public val accessControlRecordName: Output<String>? = null,
    public val initiatorName: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.AccessControlRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.AccessControlRecordArgs =
        com.pulumi.azurenative.storsimple.AccessControlRecordArgs.builder()
            .accessControlRecordName(accessControlRecordName?.applyValue({ args0 -> args0 }))
            .initiatorName(initiatorName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessControlRecordArgs].
 */
@PulumiTagMarker
public class AccessControlRecordArgsBuilder internal constructor() {
    private var accessControlRecordName: Output<String>? = null

    private var initiatorName: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the access control record.
     */
    @JvmName("cowbxnqsxfkymfkw")
    public suspend fun accessControlRecordName(`value`: Output<String>) {
        this.accessControlRecordName = value
    }

    /**
     * @param value The iSCSI initiator name (IQN).
     */
    @JvmName("kbcjekavfhxusyfh")
    public suspend fun initiatorName(`value`: Output<String>) {
        this.initiatorName = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("xjevjkudrlqirvtw")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("fxbkpoowhakhbkdt")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("mchsgjnfcxysikfe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the access control record.
     */
    @JvmName("tosnyetyrrmaoqfp")
    public suspend fun accessControlRecordName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlRecordName = mapped
    }

    /**
     * @param value The iSCSI initiator name (IQN).
     */
    @JvmName("htxqwhypumabhlsa")
    public suspend fun initiatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initiatorName = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("epsjxwwhkhdsavlm")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("rthxcnryadbpbccy")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("aqasvrodujqxyqqn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AccessControlRecordArgs = AccessControlRecordArgs(
        accessControlRecordName = accessControlRecordName,
        initiatorName = initiatorName,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
    )
}
