@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerIntrinsicSettingsResponse
import com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerSkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerIntrinsicSettingsResponse.Companion.toKotlin as managerIntrinsicSettingsResponseToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerSkuResponse.Companion.toKotlin as managerSkuResponseToKotlin

/**
 * Builder for [Manager].
 */
@PulumiTagMarker
public class ManagerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagerArgs = ManagerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagerArgsBuilder.() -> Unit) {
        val builder = ManagerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Manager {
        val builtJavaResource = com.pulumi.azurenative.storsimple.Manager(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Manager(builtJavaResource)
    }
}

/**
 * The StorSimple Manager.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2016-10-01.
 * ## Example Usage
 * ### ManagersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var manager = new AzureNative.StorSimple.Manager("manager", new()
 *     {
 *         CisIntrinsicSettings = new AzureNative.StorSimple.Inputs.ManagerIntrinsicSettingsArgs
 *         {
 *             Type = AzureNative.StorSimple.ManagerType.GardaV1,
 *         },
 *         Location = "westus",
 *         ManagerName = "ManagerForSDKTest2",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         Sku = new AzureNative.StorSimple.Inputs.ManagerSkuArgs
 *         {
 *             Name = AzureNative.StorSimple.ManagerSkuType.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewManager(ctx, "manager", &storsimple.ManagerArgs{
 * 			CisIntrinsicSettings: &storsimple.ManagerIntrinsicSettingsArgs{
 * 				Type: storsimple.ManagerTypeGardaV1,
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ManagerName:       pulumi.String("ManagerForSDKTest2"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			Sku: &storsimple.ManagerSkuArgs{
 * 				Name: storsimple.ManagerSkuTypeStandard,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.Manager;
 * import com.pulumi.azurenative.storsimple.ManagerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var manager = new Manager("manager", ManagerArgs.builder()
 *             .cisIntrinsicSettings(Map.of("type", "GardaV1"))
 *             .location("westus")
 *             .managerName("ManagerForSDKTest2")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:Manager ManagerForSDKTest2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}
 * ```
 */
public class Manager internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.Manager,
) : KotlinCustomResource(javaResource, ManagerMapper) {
    /**
     * Represents the type of StorSimple Manager.
     */
    public val cisIntrinsicSettings: Output<ManagerIntrinsicSettingsResponse>?
        get() = javaResource.cisIntrinsicSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managerIntrinsicSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The etag of the manager.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the Sku.
     */
    public val sku: Output<ManagerSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managerSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The tags attached to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagerMapper : ResourceMapper<Manager> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.Manager::class == javaResource::class

    override fun map(javaResource: Resource): Manager = Manager(
        javaResource as
            com.pulumi.azurenative.storsimple.Manager,
    )
}

/**
 * @see [Manager].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Manager].
 */
public suspend fun manager(name: String, block: suspend ManagerResourceBuilder.() -> Unit):
    Manager {
    val builder = ManagerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Manager].
 * @param name The _unique_ name of the resulting resource.
 */
public fun manager(name: String): Manager {
    val builder = ManagerResourceBuilder()
    builder.name(name)
    return builder.build()
}
