@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getAccessControlRecordPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getBackupPolicyPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getBackupSchedulePlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getBandwidthSettingPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getManagerDevicePublicEncryptionKeyPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getManagerExtendedInfoPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getManagerPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getStorageAccountCredentialPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getVolumeContainerPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.getVolumePlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.listDeviceFailoverSetsPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.listDeviceFailoverTarsPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.listManagerActivationKeyPlain
import com.pulumi.azurenative.storsimple.StorsimpleFunctions.listManagerPublicEncryptionKeyPlain
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetAccessControlRecordPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetAccessControlRecordPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBackupPolicyPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBackupPolicyPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBackupSchedulePlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBackupSchedulePlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBandwidthSettingPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetBandwidthSettingPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerDevicePublicEncryptionKeyPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerDevicePublicEncryptionKeyPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerExtendedInfoPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerExtendedInfoPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetManagerPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetStorageAccountCredentialPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetStorageAccountCredentialPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetVolumeContainerPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetVolumeContainerPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListDeviceFailoverSetsPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListDeviceFailoverSetsPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListDeviceFailoverTarsPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListDeviceFailoverTarsPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListManagerActivationKeyPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListManagerActivationKeyPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListManagerPublicEncryptionKeyPlainArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ListManagerPublicEncryptionKeyPlainArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetAccessControlRecordResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBackupPolicyResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBackupScheduleResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBandwidthSettingResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerDevicePublicEncryptionKeyResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerExtendedInfoResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetStorageAccountCredentialResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetVolumeContainerResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetVolumeResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListDeviceFailoverSetsResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListDeviceFailoverTarsResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListManagerActivationKeyResult
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListManagerPublicEncryptionKeyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetAccessControlRecordResult.Companion.toKotlin as getAccessControlRecordResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBackupPolicyResult.Companion.toKotlin as getBackupPolicyResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBackupScheduleResult.Companion.toKotlin as getBackupScheduleResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetBandwidthSettingResult.Companion.toKotlin as getBandwidthSettingResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerDevicePublicEncryptionKeyResult.Companion.toKotlin as getManagerDevicePublicEncryptionKeyResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerExtendedInfoResult.Companion.toKotlin as getManagerExtendedInfoResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetManagerResult.Companion.toKotlin as getManagerResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetStorageAccountCredentialResult.Companion.toKotlin as getStorageAccountCredentialResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetVolumeContainerResult.Companion.toKotlin as getVolumeContainerResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListDeviceFailoverSetsResult.Companion.toKotlin as listDeviceFailoverSetsResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListDeviceFailoverTarsResult.Companion.toKotlin as listDeviceFailoverTarsResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListManagerActivationKeyResult.Companion.toKotlin as listManagerActivationKeyResultToKotlin
import com.pulumi.azurenative.storsimple.kotlin.outputs.ListManagerPublicEncryptionKeyResult.Companion.toKotlin as listManagerPublicEncryptionKeyResultToKotlin

public object StorsimpleFunctions {
    /**
     * Returns the properties of the specified access control record name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The access control record.
     */
    public suspend fun getAccessControlRecord(argument: GetAccessControlRecordPlainArgs):
        GetAccessControlRecordResult =
        getAccessControlRecordResultToKotlin(getAccessControlRecordPlain(argument.toJava()).await())

    /**
     * @see [getAccessControlRecord].
     * @param accessControlRecordName Name of access control record to be fetched.
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The access control record.
     */
    public suspend fun getAccessControlRecord(
        accessControlRecordName: String,
        managerName: String,
        resourceGroupName: String,
    ): GetAccessControlRecordResult {
        val argument = GetAccessControlRecordPlainArgs(
            accessControlRecordName = accessControlRecordName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessControlRecordResultToKotlin(getAccessControlRecordPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessControlRecord].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetAccessControlRecordPlainArgs].
     * @return The access control record.
     */
    public suspend
    fun getAccessControlRecord(argument: suspend GetAccessControlRecordPlainArgsBuilder.() -> Unit):
        GetAccessControlRecordResult {
        val builder = GetAccessControlRecordPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessControlRecordResultToKotlin(getAccessControlRecordPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified backup policy name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The backup policy.
     */
    public suspend fun getBackupPolicy(argument: GetBackupPolicyPlainArgs): GetBackupPolicyResult =
        getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBackupPolicy].
     * @param backupPolicyName The name of backup policy to be fetched.
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The backup policy.
     */
    public suspend fun getBackupPolicy(
        backupPolicyName: String,
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
    ): GetBackupPolicyResult {
        val argument = GetBackupPolicyPlainArgs(
            backupPolicyName = backupPolicyName,
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetBackupPolicyPlainArgs].
     * @return The backup policy.
     */
    public suspend fun getBackupPolicy(argument: suspend GetBackupPolicyPlainArgsBuilder.() -> Unit):
        GetBackupPolicyResult {
        val builder = GetBackupPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified backup schedule name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The backup schedule.
     */
    public suspend fun getBackupSchedule(argument: GetBackupSchedulePlainArgs):
        GetBackupScheduleResult =
        getBackupScheduleResultToKotlin(getBackupSchedulePlain(argument.toJava()).await())

    /**
     * @see [getBackupSchedule].
     * @param backupPolicyName The backup policy name.
     * @param backupScheduleName The name of the backup schedule to be fetched
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The backup schedule.
     */
    public suspend fun getBackupSchedule(
        backupPolicyName: String,
        backupScheduleName: String,
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
    ): GetBackupScheduleResult {
        val argument = GetBackupSchedulePlainArgs(
            backupPolicyName = backupPolicyName,
            backupScheduleName = backupScheduleName,
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getBackupScheduleResultToKotlin(getBackupSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetBackupSchedulePlainArgs].
     * @return The backup schedule.
     */
    public suspend
    fun getBackupSchedule(argument: suspend GetBackupSchedulePlainArgsBuilder.() -> Unit):
        GetBackupScheduleResult {
        val builder = GetBackupSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupScheduleResultToKotlin(getBackupSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of the specified bandwidth setting name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The bandwidth setting.
     */
    public suspend fun getBandwidthSetting(argument: GetBandwidthSettingPlainArgs):
        GetBandwidthSettingResult =
        getBandwidthSettingResultToKotlin(getBandwidthSettingPlain(argument.toJava()).await())

    /**
     * @see [getBandwidthSetting].
     * @param bandwidthSettingName The name of bandwidth setting to be fetched.
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The bandwidth setting.
     */
    public suspend fun getBandwidthSetting(
        bandwidthSettingName: String,
        managerName: String,
        resourceGroupName: String,
    ): GetBandwidthSettingResult {
        val argument = GetBandwidthSettingPlainArgs(
            bandwidthSettingName = bandwidthSettingName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getBandwidthSettingResultToKotlin(getBandwidthSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBandwidthSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetBandwidthSettingPlainArgs].
     * @return The bandwidth setting.
     */
    public suspend
    fun getBandwidthSetting(argument: suspend GetBandwidthSettingPlainArgsBuilder.() -> Unit):
        GetBandwidthSettingResult {
        val builder = GetBandwidthSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBandwidthSettingResultToKotlin(getBandwidthSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of the specified manager name.
     * Azure REST API version: 2017-06-01.
     * Other available API versions: 2016-10-01.
     * @param argument null
     * @return The StorSimple Manager.
     */
    public suspend fun getManager(argument: GetManagerPlainArgs): GetManagerResult =
        getManagerResultToKotlin(getManagerPlain(argument.toJava()).await())

    /**
     * @see [getManager].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The StorSimple Manager.
     */
    public suspend fun getManager(managerName: String, resourceGroupName: String): GetManagerResult {
        val argument = GetManagerPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getManagerResultToKotlin(getManagerPlain(argument.toJava()).await())
    }

    /**
     * @see [getManager].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetManagerPlainArgs].
     * @return The StorSimple Manager.
     */
    public suspend fun getManager(argument: suspend GetManagerPlainArgsBuilder.() -> Unit):
        GetManagerResult {
        val builder = GetManagerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagerResultToKotlin(getManagerPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the public encryption key of the device.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The public key.
     */
    public suspend
    fun getManagerDevicePublicEncryptionKey(argument: GetManagerDevicePublicEncryptionKeyPlainArgs):
        GetManagerDevicePublicEncryptionKeyResult =
        getManagerDevicePublicEncryptionKeyResultToKotlin(getManagerDevicePublicEncryptionKeyPlain(argument.toJava()).await())

    /**
     * @see [getManagerDevicePublicEncryptionKey].
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The public key.
     */
    public suspend fun getManagerDevicePublicEncryptionKey(
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
    ): GetManagerDevicePublicEncryptionKeyResult {
        val argument = GetManagerDevicePublicEncryptionKeyPlainArgs(
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getManagerDevicePublicEncryptionKeyResultToKotlin(getManagerDevicePublicEncryptionKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagerDevicePublicEncryptionKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetManagerDevicePublicEncryptionKeyPlainArgs].
     * @return The public key.
     */
    public suspend
    fun getManagerDevicePublicEncryptionKey(argument: suspend GetManagerDevicePublicEncryptionKeyPlainArgsBuilder.() -> Unit):
        GetManagerDevicePublicEncryptionKeyResult {
        val builder = GetManagerDevicePublicEncryptionKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagerDevicePublicEncryptionKeyResultToKotlin(getManagerDevicePublicEncryptionKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the extended information of the specified manager name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The extended info of the manager.
     */
    public suspend fun getManagerExtendedInfo(argument: GetManagerExtendedInfoPlainArgs):
        GetManagerExtendedInfoResult =
        getManagerExtendedInfoResultToKotlin(getManagerExtendedInfoPlain(argument.toJava()).await())

    /**
     * @see [getManagerExtendedInfo].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The extended info of the manager.
     */
    public suspend fun getManagerExtendedInfo(managerName: String, resourceGroupName: String):
        GetManagerExtendedInfoResult {
        val argument = GetManagerExtendedInfoPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return getManagerExtendedInfoResultToKotlin(getManagerExtendedInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagerExtendedInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetManagerExtendedInfoPlainArgs].
     * @return The extended info of the manager.
     */
    public suspend
    fun getManagerExtendedInfo(argument: suspend GetManagerExtendedInfoPlainArgsBuilder.() -> Unit):
        GetManagerExtendedInfoResult {
        val builder = GetManagerExtendedInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagerExtendedInfoResultToKotlin(getManagerExtendedInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified storage account credential name.
     * Azure REST API version: 2017-06-01.
     * Other available API versions: 2016-10-01.
     * @param argument null
     * @return The storage account credential.
     */
    public suspend fun getStorageAccountCredential(argument: GetStorageAccountCredentialPlainArgs):
        GetStorageAccountCredentialResult =
        getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(argument.toJava()).await())

    /**
     * @see [getStorageAccountCredential].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @param storageAccountCredentialName The name of storage account credential to be fetched.
     * @return The storage account credential.
     */
    public suspend fun getStorageAccountCredential(
        managerName: String,
        resourceGroupName: String,
        storageAccountCredentialName: String,
    ): GetStorageAccountCredentialResult {
        val argument = GetStorageAccountCredentialPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
            storageAccountCredentialName = storageAccountCredentialName,
        )
        return getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageAccountCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetStorageAccountCredentialPlainArgs].
     * @return The storage account credential.
     */
    public suspend
    fun getStorageAccountCredential(argument: suspend GetStorageAccountCredentialPlainArgsBuilder.() -> Unit):
        GetStorageAccountCredentialResult {
        val builder = GetStorageAccountCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageAccountCredentialResultToKotlin(getStorageAccountCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of the specified volume name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The volume.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @param volumeContainerName The volume container name.
     * @param volumeName The volume name.
     * @return The volume.
     */
    public suspend fun getVolume(
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
        volumeContainerName: String,
        volumeName: String,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
            volumeContainerName = volumeContainerName,
            volumeName = volumeName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return The volume.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit):
        GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified volume container name.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The volume container.
     */
    public suspend fun getVolumeContainer(argument: GetVolumeContainerPlainArgs):
        GetVolumeContainerResult =
        getVolumeContainerResultToKotlin(getVolumeContainerPlain(argument.toJava()).await())

    /**
     * @see [getVolumeContainer].
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @param volumeContainerName The name of the volume container.
     * @return The volume container.
     */
    public suspend fun getVolumeContainer(
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
        volumeContainerName: String,
    ): GetVolumeContainerResult {
        val argument = GetVolumeContainerPlainArgs(
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
            volumeContainerName = volumeContainerName,
        )
        return getVolumeContainerResultToKotlin(getVolumeContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;GetVolumeContainerPlainArgs].
     * @return The volume container.
     */
    public suspend
    fun getVolumeContainer(argument: suspend GetVolumeContainerPlainArgsBuilder.() -> Unit):
        GetVolumeContainerResult {
        val builder = GetVolumeContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeContainerResultToKotlin(getVolumeContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns all failover sets for a given device and their eligibility for participating in a failover. A failover set refers to a set of volume containers that need to be failed-over as a single unit to maintain data integrity.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The list of failover sets.
     */
    public suspend fun listDeviceFailoverSets(argument: ListDeviceFailoverSetsPlainArgs):
        ListDeviceFailoverSetsResult =
        listDeviceFailoverSetsResultToKotlin(listDeviceFailoverSetsPlain(argument.toJava()).await())

    /**
     * @see [listDeviceFailoverSets].
     * @param deviceName The device name
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The list of failover sets.
     */
    public suspend fun listDeviceFailoverSets(
        deviceName: String,
        managerName: String,
        resourceGroupName: String,
    ): ListDeviceFailoverSetsResult {
        val argument = ListDeviceFailoverSetsPlainArgs(
            deviceName = deviceName,
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return listDeviceFailoverSetsResultToKotlin(listDeviceFailoverSetsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDeviceFailoverSets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;ListDeviceFailoverSetsPlainArgs].
     * @return The list of failover sets.
     */
    public suspend
    fun listDeviceFailoverSets(argument: suspend ListDeviceFailoverSetsPlainArgsBuilder.() -> Unit):
        ListDeviceFailoverSetsResult {
        val builder = ListDeviceFailoverSetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDeviceFailoverSetsResultToKotlin(listDeviceFailoverSetsPlain(builtArgument.toJava()).await())
    }

    /**
     * Given a list of volume containers to be failed over from a source device, this method returns the eligibility result, as a failover target, for all devices under that resource.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The list of all devices in a resource and their eligibility status as a failover target device.
     */
    public suspend fun listDeviceFailoverTars(argument: ListDeviceFailoverTarsPlainArgs):
        ListDeviceFailoverTarsResult =
        listDeviceFailoverTarsResultToKotlin(listDeviceFailoverTarsPlain(argument.toJava()).await())

    /**
     * @see [listDeviceFailoverTars].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @param sourceDeviceName The source device name on which failover is performed.
     * @param volumeContainers The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
     * @return The list of all devices in a resource and their eligibility status as a failover target device.
     */
    public suspend fun listDeviceFailoverTars(
        managerName: String,
        resourceGroupName: String,
        sourceDeviceName: String,
        volumeContainers: List<String>? = null,
    ): ListDeviceFailoverTarsResult {
        val argument = ListDeviceFailoverTarsPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
            sourceDeviceName = sourceDeviceName,
            volumeContainers = volumeContainers,
        )
        return listDeviceFailoverTarsResultToKotlin(listDeviceFailoverTarsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDeviceFailoverTars].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;ListDeviceFailoverTarsPlainArgs].
     * @return The list of all devices in a resource and their eligibility status as a failover target device.
     */
    public suspend
    fun listDeviceFailoverTars(argument: suspend ListDeviceFailoverTarsPlainArgsBuilder.() -> Unit):
        ListDeviceFailoverTarsResult {
        val builder = ListDeviceFailoverTarsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDeviceFailoverTarsResultToKotlin(listDeviceFailoverTarsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the activation key of the manager.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return The key.
     */
    public suspend fun listManagerActivationKey(argument: ListManagerActivationKeyPlainArgs):
        ListManagerActivationKeyResult =
        listManagerActivationKeyResultToKotlin(listManagerActivationKeyPlain(argument.toJava()).await())

    /**
     * @see [listManagerActivationKey].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return The key.
     */
    public suspend fun listManagerActivationKey(managerName: String, resourceGroupName: String):
        ListManagerActivationKeyResult {
        val argument = ListManagerActivationKeyPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return listManagerActivationKeyResultToKotlin(listManagerActivationKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listManagerActivationKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;ListManagerActivationKeyPlainArgs].
     * @return The key.
     */
    public suspend
    fun listManagerActivationKey(argument: suspend ListManagerActivationKeyPlainArgsBuilder.() -> Unit):
        ListManagerActivationKeyResult {
        val builder = ListManagerActivationKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagerActivationKeyResultToKotlin(listManagerActivationKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the symmetric encrypted public encryption key of the manager.
     * Azure REST API version: 2017-06-01.
     * @param argument null
     * @return Represents the secrets encrypted using Symmetric Encryption Key.
     */
    public suspend
    fun listManagerPublicEncryptionKey(argument: ListManagerPublicEncryptionKeyPlainArgs):
        ListManagerPublicEncryptionKeyResult =
        listManagerPublicEncryptionKeyResultToKotlin(listManagerPublicEncryptionKeyPlain(argument.toJava()).await())

    /**
     * @see [listManagerPublicEncryptionKey].
     * @param managerName The manager name
     * @param resourceGroupName The resource group name
     * @return Represents the secrets encrypted using Symmetric Encryption Key.
     */
    public suspend fun listManagerPublicEncryptionKey(managerName: String, resourceGroupName: String):
        ListManagerPublicEncryptionKeyResult {
        val argument = ListManagerPublicEncryptionKeyPlainArgs(
            managerName = managerName,
            resourceGroupName = resourceGroupName,
        )
        return listManagerPublicEncryptionKeyResultToKotlin(listManagerPublicEncryptionKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listManagerPublicEncryptionKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storsimple&#46;kotlin&#46;inputs&#46;ListManagerPublicEncryptionKeyPlainArgs].
     * @return Represents the secrets encrypted using Symmetric Encryption Key.
     */
    public suspend
    fun listManagerPublicEncryptionKey(argument: suspend ListManagerPublicEncryptionKeyPlainArgsBuilder.() -> Unit):
        ListManagerPublicEncryptionKeyResult {
        val builder = ListManagerPublicEncryptionKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagerPublicEncryptionKeyResultToKotlin(listManagerPublicEncryptionKeyPlain(builtArgument.toJava()).await())
    }
}
