@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.VolumeArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.azurenative.storsimple.kotlin.enums.MonitoringStatus
import com.pulumi.azurenative.storsimple.kotlin.enums.VolumeStatus
import com.pulumi.azurenative.storsimple.kotlin.enums.VolumeType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The volume.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### VolumesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.StorSimple.Volume("volume", new()
 *     {
 *         AccessControlRecordIds = new[]
 *         {
 *             "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2",
 *         },
 *         DeviceName = "Device05ForSDKTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         MonitoringStatus = AzureNative.StorSimple.MonitoringStatus.Enabled,
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         SizeInBytes = 5368709120,
 *         VolumeContainerName = "VolumeContainerForSDKTest",
 *         VolumeName = "Volume1ForSDKTest",
 *         VolumeStatus = AzureNative.StorSimple.VolumeStatus.Offline,
 *         VolumeType = AzureNative.StorSimple.VolumeType.Tiered,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewVolume(ctx, "volume", &storsimple.VolumeArgs{
 * 			AccessControlRecordIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2"),
 * 			},
 * 			DeviceName:          pulumi.String("Device05ForSDKTest"),
 * 			ManagerName:         pulumi.String("ManagerForSDKTest1"),
 * 			MonitoringStatus:    storsimple.MonitoringStatusEnabled,
 * 			ResourceGroupName:   pulumi.String("ResourceGroupForSDKTest"),
 * 			SizeInBytes:         pulumi.Float64(5368709120),
 * 			VolumeContainerName: pulumi.String("VolumeContainerForSDKTest"),
 * 			VolumeName:          pulumi.String("Volume1ForSDKTest"),
 * 			VolumeStatus:        storsimple.VolumeStatusOffline,
 * 			VolumeType:          storsimple.VolumeTypeTiered,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.Volume;
 * import com.pulumi.azurenative.storsimple.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .accessControlRecordIds("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")
 *             .deviceName("Device05ForSDKTest")
 *             .managerName("ManagerForSDKTest1")
 *             .monitoringStatus("Enabled")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sizeInBytes(5368709120)
 *             .volumeContainerName("VolumeContainerForSDKTest")
 *             .volumeName("Volume1ForSDKTest")
 *             .volumeStatus("Offline")
 *             .volumeType("Tiered")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:Volume Volume1ForSDKTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}
 * ```
 * @property accessControlRecordIds The IDs of the access control records, associated with the volume.
 * @property deviceName The device name
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property monitoringStatus The monitoring status of the volume.
 * @property resourceGroupName The resource group name
 * @property sizeInBytes The size of the volume in bytes.
 * @property volumeContainerName The volume container name.
 * @property volumeName The volume name.
 * @property volumeStatus The volume status.
 * @property volumeType The type of the volume.
 */
public data class VolumeArgs(
    public val accessControlRecordIds: Output<List<String>>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val monitoringStatus: Output<MonitoringStatus>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sizeInBytes: Output<Double>? = null,
    public val volumeContainerName: Output<String>? = null,
    public val volumeName: Output<String>? = null,
    public val volumeStatus: Output<VolumeStatus>? = null,
    public val volumeType: Output<VolumeType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.VolumeArgs =
        com.pulumi.azurenative.storsimple.VolumeArgs.builder()
            .accessControlRecordIds(
                accessControlRecordIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .monitoringStatus(monitoringStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sizeInBytes(sizeInBytes?.applyValue({ args0 -> args0 }))
            .volumeContainerName(volumeContainerName?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 }))
            .volumeStatus(volumeStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeType(volumeType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var accessControlRecordIds: Output<List<String>>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var monitoringStatus: Output<MonitoringStatus>? = null

    private var resourceGroupName: Output<String>? = null

    private var sizeInBytes: Output<Double>? = null

    private var volumeContainerName: Output<String>? = null

    private var volumeName: Output<String>? = null

    private var volumeStatus: Output<VolumeStatus>? = null

    private var volumeType: Output<VolumeType>? = null

    /**
     * @param value The IDs of the access control records, associated with the volume.
     */
    @JvmName("tlhddmbvdekknoqs")
    public suspend fun accessControlRecordIds(`value`: Output<List<String>>) {
        this.accessControlRecordIds = value
    }

    @JvmName("phsjewyiujpiqlfh")
    public suspend fun accessControlRecordIds(vararg values: Output<String>) {
        this.accessControlRecordIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the access control records, associated with the volume.
     */
    @JvmName("yblekdvisokmtxkx")
    public suspend fun accessControlRecordIds(values: List<Output<String>>) {
        this.accessControlRecordIds = Output.all(values)
    }

    /**
     * @param value The device name
     */
    @JvmName("kbicwycjbbrjixak")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("dxcoblkrkjcguxeg")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("jaumlbeybydwjtwo")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The monitoring status of the volume.
     */
    @JvmName("lxkinvkejcbjqerd")
    public suspend fun monitoringStatus(`value`: Output<MonitoringStatus>) {
        this.monitoringStatus = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("fhnxbfmkraoonpmq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The size of the volume in bytes.
     */
    @JvmName("gnjksufncqnofvve")
    public suspend fun sizeInBytes(`value`: Output<Double>) {
        this.sizeInBytes = value
    }

    /**
     * @param value The volume container name.
     */
    @JvmName("gylyfumpqykeecog")
    public suspend fun volumeContainerName(`value`: Output<String>) {
        this.volumeContainerName = value
    }

    /**
     * @param value The volume name.
     */
    @JvmName("ynugsokppncvadbl")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The volume status.
     */
    @JvmName("wkqaupodvngkjhpw")
    public suspend fun volumeStatus(`value`: Output<VolumeStatus>) {
        this.volumeStatus = value
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("rfdxedjtkbnlavfg")
    public suspend fun volumeType(`value`: Output<VolumeType>) {
        this.volumeType = value
    }

    /**
     * @param value The IDs of the access control records, associated with the volume.
     */
    @JvmName("nsnjecbkvtwoblli")
    public suspend fun accessControlRecordIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlRecordIds = mapped
    }

    /**
     * @param values The IDs of the access control records, associated with the volume.
     */
    @JvmName("kapqqocgqrmfrcpp")
    public suspend fun accessControlRecordIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlRecordIds = mapped
    }

    /**
     * @param value The device name
     */
    @JvmName("idkeiqhhhxrkkdpu")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("lreocyngfimmewaf")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("jdgjufcupefytuyo")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The monitoring status of the volume.
     */
    @JvmName("pmkqqmcnarisqmqx")
    public suspend fun monitoringStatus(`value`: MonitoringStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("pdiqhuovklxakdpi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The size of the volume in bytes.
     */
    @JvmName("fqmtxowpcnxnbdne")
    public suspend fun sizeInBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInBytes = mapped
    }

    /**
     * @param value The volume container name.
     */
    @JvmName("rkbpxsbhjowiqpdx")
    public suspend fun volumeContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeContainerName = mapped
    }

    /**
     * @param value The volume name.
     */
    @JvmName("ygmmhqxtpegwyoil")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    /**
     * @param value The volume status.
     */
    @JvmName("jstekegbdpnaekfw")
    public suspend fun volumeStatus(`value`: VolumeStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeStatus = mapped
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("khnloeyklpqvbutx")
    public suspend fun volumeType(`value`: VolumeType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        accessControlRecordIds = accessControlRecordIds,
        deviceName = deviceName,
        kind = kind,
        managerName = managerName,
        monitoringStatus = monitoringStatus,
        resourceGroupName = resourceGroupName,
        sizeInBytes = sizeInBytes,
        volumeContainerName = volumeContainerName,
        volumeName = volumeName,
        volumeStatus = volumeStatus,
        volumeType = volumeType,
    )
}
