@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.VolumeContainerArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.azurenative.storsimple.kotlin.inputs.AsymmetricEncryptedSecretArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.AsymmetricEncryptedSecretArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The volume container.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### VolumeContainersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeContainer = new AzureNative.StorSimple.VolumeContainer("volumeContainer", new()
 *     {
 *         BandwidthSettingId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1",
 *         DeviceName = "Device05ForSDKTest",
 *         EncryptionKey = new AzureNative.StorSimple.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.StorSimple.EncryptionAlgorithm.RSAES_PKCS1_v_1_5,
 *             EncryptionCertThumbprint = "A872A2DF196AC7682EE24791E7DE2E2A360F5926",
 *             Value = "R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw==",
 *         },
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording",
 *         VolumeContainerName = "VolumeContainerForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewVolumeContainer(ctx, "volumeContainer", &storsimple.VolumeContainerArgs{
 * 			BandwidthSettingId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1"),
 * 			DeviceName:         pulumi.String("Device05ForSDKTest"),
 * 			EncryptionKey: &storsimple.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      storsimple.EncryptionAlgorithm_RSAES_PKCS1_v_1_5,
 * 				EncryptionCertThumbprint: pulumi.String("A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 * 				Value:                    pulumi.String("R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw=="),
 * 			},
 * 			ManagerName:                pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:          pulumi.String("ResourceGroupForSDKTest"),
 * 			StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording"),
 * 			VolumeContainerName:        pulumi.String("VolumeContainerForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.VolumeContainer;
 * import com.pulumi.azurenative.storsimple.VolumeContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeContainer = new VolumeContainer("volumeContainer", VolumeContainerArgs.builder()
 *             .bandwidthSettingId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1")
 *             .deviceName("Device05ForSDKTest")
 *             .encryptionKey(Map.ofEntries(
 *                 Map.entry("encryptionAlgorithm", "RSAES_PKCS1_v_1_5"),
 *                 Map.entry("encryptionCertThumbprint", "A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 *                 Map.entry("value", "R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw==")
 *             ))
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .storageAccountCredentialId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording")
 *             .volumeContainerName("VolumeContainerForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:VolumeContainer VolumeContainerForSDKTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}
 * ```
 * @property bandWidthRateInMbps The bandwidth-rate set on the volume container.
 * @property bandwidthSettingId The ID of the bandwidth setting associated with the volume container.
 * @property deviceName The device name
 * @property encryptionKey The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property storageAccountCredentialId The path ID of storage account associated with the volume container.
 * @property volumeContainerName The name of the volume container.
 */
public data class VolumeContainerArgs(
    public val bandWidthRateInMbps: Output<Int>? = null,
    public val bandwidthSettingId: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val encryptionKey: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountCredentialId: Output<String>? = null,
    public val volumeContainerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.VolumeContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.VolumeContainerArgs =
        com.pulumi.azurenative.storsimple.VolumeContainerArgs.builder()
            .bandWidthRateInMbps(bandWidthRateInMbps?.applyValue({ args0 -> args0 }))
            .bandwidthSettingId(bandwidthSettingId?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountCredentialId(storageAccountCredentialId?.applyValue({ args0 -> args0 }))
            .volumeContainerName(volumeContainerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeContainerArgs].
 */
@PulumiTagMarker
public class VolumeContainerArgsBuilder internal constructor() {
    private var bandWidthRateInMbps: Output<Int>? = null

    private var bandwidthSettingId: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var encryptionKey: Output<AsymmetricEncryptedSecretArgs>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountCredentialId: Output<String>? = null

    private var volumeContainerName: Output<String>? = null

    /**
     * @param value The bandwidth-rate set on the volume container.
     */
    @JvmName("bmdcnjxfndsfwwke")
    public suspend fun bandWidthRateInMbps(`value`: Output<Int>) {
        this.bandWidthRateInMbps = value
    }

    /**
     * @param value The ID of the bandwidth setting associated with the volume container.
     */
    @JvmName("phoawbrqwmlckggg")
    public suspend fun bandwidthSettingId(`value`: Output<String>) {
        this.bandwidthSettingId = value
    }

    /**
     * @param value The device name
     */
    @JvmName("lodgaoflxystyqdb")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
     */
    @JvmName("koicqihivvcyeiix")
    public suspend fun encryptionKey(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.encryptionKey = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("hbfqlmtqyoqmsnbo")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("dcgdfwoumgfjoaly")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("svorkpvojonyxrdo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The path ID of storage account associated with the volume container.
     */
    @JvmName("ylqdipjbakglbpjh")
    public suspend fun storageAccountCredentialId(`value`: Output<String>) {
        this.storageAccountCredentialId = value
    }

    /**
     * @param value The name of the volume container.
     */
    @JvmName("pctmirrbfsycpjgd")
    public suspend fun volumeContainerName(`value`: Output<String>) {
        this.volumeContainerName = value
    }

    /**
     * @param value The bandwidth-rate set on the volume container.
     */
    @JvmName("uyikeajlnslouxwl")
    public suspend fun bandWidthRateInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandWidthRateInMbps = mapped
    }

    /**
     * @param value The ID of the bandwidth setting associated with the volume container.
     */
    @JvmName("fnpsvhimqnispqwi")
    public suspend fun bandwidthSettingId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthSettingId = mapped
    }

    /**
     * @param value The device name
     */
    @JvmName("hinljgnjxtlhchno")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
     */
    @JvmName("txeqywyxsklsjwut")
    public suspend fun encryptionKey(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param argument The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
     */
    @JvmName("shlfxmsrwakbbocy")
    public suspend
    fun encryptionKey(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionKey = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("axnjuetrylilyogn")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("irillxgspvbipcpe")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("blfbpnacirbvefok")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The path ID of storage account associated with the volume container.
     */
    @JvmName("fntcrbyrwhrpmyrl")
    public suspend fun storageAccountCredentialId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountCredentialId = mapped
    }

    /**
     * @param value The name of the volume container.
     */
    @JvmName("txenywuvcbwyastm")
    public suspend fun volumeContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeContainerName = mapped
    }

    internal fun build(): VolumeContainerArgs = VolumeContainerArgs(
        bandWidthRateInMbps = bandWidthRateInMbps,
        bandwidthSettingId = bandwidthSettingId,
        deviceName = deviceName,
        encryptionKey = encryptionKey,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
        storageAccountCredentialId = storageAccountCredentialId,
        volumeContainerName = volumeContainerName,
    )
}
