@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetBackupPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backupPolicyName The name of backup policy to be fetched.
 * @property deviceName The device name
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class GetBackupPolicyPlainArgs(
    public val backupPolicyName: String,
    public val deviceName: String,
    public val managerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetBackupPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetBackupPolicyPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetBackupPolicyPlainArgs.builder()
            .backupPolicyName(backupPolicyName.let({ args0 -> args0 }))
            .deviceName(deviceName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPolicyPlainArgsBuilder internal constructor() {
    private var backupPolicyName: String? = null

    private var deviceName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of backup policy to be fetched.
     */
    @JvmName("tlfaefthiljiwyga")
    public suspend fun backupPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The device name
     */
    @JvmName("xgxrsgfcjuonwwyi")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("fpheeksasnhsykky")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("mdlvsqxkekhtkrlk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBackupPolicyPlainArgs = GetBackupPolicyPlainArgs(
        backupPolicyName = backupPolicyName ?: throw PulumiNullFieldException("backupPolicyName"),
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
