@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The eligibility result of failover set, for failover.
 * @property errorMessage The error message, if the failover set is not eligible for failover.
 * @property isEligibleForFailover Represents if this failover set is eligible for failover or not.
 */
public data class FailoverSetEligibilityResultResponse(
    public val errorMessage: String? = null,
    public val isEligibleForFailover: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.FailoverSetEligibilityResultResponse):
            FailoverSetEligibilityResultResponse = FailoverSetEligibilityResultResponse(
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            isEligibleForFailover = javaType.isEligibleForFailover().map({ args0 -> args0 }).orElse(null),
        )
    }
}
