@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The metadata of a volume that has valid cloud snapshot.
 * @property backupCreatedDate The date at which the snapshot was taken.
 * @property backupElementId The path ID of the backup-element for this volume, inside the backup set.
 * @property backupId The path ID of the backup set.
 * @property backupPolicyId The path ID of the backup policy using which the snapshot was taken.
 * @property sizeInBytes The size of the volume in bytes at the time the snapshot was taken.
 * @property volumeId The path ID of the volume.
 * @property volumeType The type of the volume.
 */
public data class VolumeFailoverMetadataResponse(
    public val backupCreatedDate: String? = null,
    public val backupElementId: String? = null,
    public val backupId: String? = null,
    public val backupPolicyId: String? = null,
    public val sizeInBytes: Double? = null,
    public val volumeId: String? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.VolumeFailoverMetadataResponse):
            VolumeFailoverMetadataResponse = VolumeFailoverMetadataResponse(
            backupCreatedDate = javaType.backupCreatedDate().map({ args0 -> args0 }).orElse(null),
            backupElementId = javaType.backupElementId().map({ args0 -> args0 }).orElse(null),
            backupId = javaType.backupId().map({ args0 -> args0 }).orElse(null),
            backupPolicyId = javaType.backupPolicyId().map({ args0 -> args0 }).orElse(null),
            sizeInBytes = javaType.sizeInBytes().map({ args0 -> args0 }).orElse(null),
            volumeId = javaType.volumeId().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
