@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.StreamingJobArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.CompatibilityLevel
import com.pulumi.azurenative.streamanalytics.kotlin.enums.ContentStoragePolicy
import com.pulumi.azurenative.streamanalytics.kotlin.enums.EventsOutOfOrderPolicy
import com.pulumi.azurenative.streamanalytics.kotlin.enums.JobType
import com.pulumi.azurenative.streamanalytics.kotlin.enums.OutputErrorPolicy
import com.pulumi.azurenative.streamanalytics.kotlin.enums.OutputStartMode
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ClusterInfoArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ClusterInfoArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.FunctionArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.FunctionArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.InputArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.InputArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.JobStorageAccountArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.JobStorageAccountArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.OutputArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.OutputArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.TransformationArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.TransformationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A streaming job object, containing all information associated with the named streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2017-04-01-preview, 2021-10-01-preview.
 * ## Example Usage
 * ### Create a complete streaming job (a streaming job with a transformation, at least 1 input and at least 1 output)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingJob = new AzureNative.StreamAnalytics.StreamingJob("streamingJob", new()
 *     {
 *         CompatibilityLevel = "1.0",
 *         DataLocale = "en-US",
 *         EventsLateArrivalMaxDelayInSeconds = 5,
 *         EventsOutOfOrderMaxDelayInSeconds = 0,
 *         EventsOutOfOrderPolicy = "Drop",
 *         Functions = new[] {},
 *         Inputs = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.InputArgs
 *             {
 *                 Name = "inputtest",
 *                 Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *                 {
 *                     Datasource = new AzureNative.StreamAnalytics.Inputs.BlobStreamInputDataSourceArgs
 *                     {
 *                         Container = "containerName",
 *                         PathPattern = "",
 *                         StorageAccounts = new[]
 *                         {
 *                             new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                             {
 *                                 AccountKey = "yourAccountKey==",
 *                                 AccountName = "yourAccountName",
 *                             },
 *                         },
 *                         Type = "Microsoft.Storage/Blob",
 *                     },
 *                     Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *                     {
 *                         Encoding = "UTF8",
 *                         Type = "Json",
 *                     },
 *                     Type = "Stream",
 *                 },
 *             },
 *         },
 *         JobName = "sj7804",
 *         Location = "West US",
 *         OutputErrorPolicy = "Drop",
 *         Outputs = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.OutputArgs
 *             {
 *                 Datasource = new AzureNative.StreamAnalytics.Inputs.AzureSqlDatabaseOutputDataSourceArgs
 *                 {
 *                     Database = "databaseName",
 *                     Password = "userPassword",
 *                     Server = "serverName",
 *                     Table = "tableName",
 *                     Type = "Microsoft.Sql/Server/Database",
 *                     User = "<user>",
 *                 },
 *                 Name = "outputtest",
 *             },
 *         },
 *         ResourceGroupName = "sjrg3276",
 *         Sku = new AzureNative.StreamAnalytics.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key3", "value3" },
 *             { "randomKey", "randomValue" },
 *         },
 *         Transformation = new AzureNative.StreamAnalytics.Inputs.TransformationArgs
 *         {
 *             Name = "transformationtest",
 *             Query = "Select Id, Name from inputtest",
 *             StreamingUnits = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewStreamingJob(ctx, "streamingJob", &streamanalytics.StreamingJobArgs{
 * 			CompatibilityLevel:                 pulumi.String("1.0"),
 * 			DataLocale:                         pulumi.String("en-US"),
 * 			EventsLateArrivalMaxDelayInSeconds: pulumi.Int(5),
 * 			EventsOutOfOrderMaxDelayInSeconds:  pulumi.Int(0),
 * 			EventsOutOfOrderPolicy:             pulumi.String("Drop"),
 * 			Functions:                          streamanalytics.FunctionTypeArray{},
 * 			Inputs: []streamanalytics.InputTypeArgs{
 * 				{
 * 					Name: pulumi.String("inputtest"),
 * 					Properties: {
 * 						Datasource: {
 * 							Container:   "containerName",
 * 							PathPattern: "",
 * 							StorageAccounts: []streamanalytics.StorageAccount{
 * 								{
 * 									AccountKey:  "yourAccountKey==",
 * 									AccountName: "yourAccountName",
 * 								},
 * 							},
 * 							Type: "Microsoft.Storage/Blob",
 * 						},
 * 						Serialization: {
 * 							Encoding: "UTF8",
 * 							Type:     "Json",
 * 						},
 * 						Type: "Stream",
 * 					},
 * 				},
 * 			},
 * 			JobName:           pulumi.String("sj7804"),
 * 			Location:          pulumi.String("West US"),
 * 			OutputErrorPolicy: pulumi.String("Drop"),
 * 			Outputs: []streamanalytics.OutputTypeArgs{
 * 				{
 * 					Datasource: {
 * 						Database: "databaseName",
 * 						Password: "userPassword",
 * 						Server:   "serverName",
 * 						Table:    "tableName",
 * 						Type:     "Microsoft.Sql/Server/Database",
 * 						User:     "<user>",
 * 					},
 * 					Name: pulumi.String("outputtest"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3276"),
 * 			Sku: &streamanalytics.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1":      pulumi.String("value1"),
 * 				"key3":      pulumi.String("value3"),
 * 				"randomKey": pulumi.String("randomValue"),
 * 			},
 * 			Transformation: &streamanalytics.TransformationArgs{
 * 				Name:           pulumi.String("transformationtest"),
 * 				Query:          pulumi.String("Select Id, Name from inputtest"),
 * 				StreamingUnits: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.StreamingJob;
 * import com.pulumi.azurenative.streamanalytics.StreamingJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingJob = new StreamingJob("streamingJob", StreamingJobArgs.builder()
 *             .compatibilityLevel("1.0")
 *             .dataLocale("en-US")
 *             .eventsLateArrivalMaxDelayInSeconds(5)
 *             .eventsOutOfOrderMaxDelayInSeconds(0)
 *             .eventsOutOfOrderPolicy("Drop")
 *             .functions()
 *             .inputs(Map.ofEntries(
 *                 Map.entry("name", "inputtest"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("datasource", Map.ofEntries(
 *                         Map.entry("container", "containerName"),
 *                         Map.entry("pathPattern", ""),
 *                         Map.entry("storageAccounts", Map.ofEntries(
 *                             Map.entry("accountKey", "yourAccountKey=="),
 *                             Map.entry("accountName", "yourAccountName")
 *                         )),
 *                         Map.entry("type", "Microsoft.Storage/Blob")
 *                     )),
 *                     Map.entry("serialization", Map.ofEntries(
 *                         Map.entry("encoding", "UTF8"),
 *                         Map.entry("type", "Json")
 *                     )),
 *                     Map.entry("type", "Stream")
 *                 ))
 *             ))
 *             .jobName("sj7804")
 *             .location("West US")
 *             .outputErrorPolicy("Drop")
 *             .outputs(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("database", "databaseName"),
 *                     Map.entry("password", "userPassword"),
 *                     Map.entry("server", "serverName"),
 *                     Map.entry("table", "tableName"),
 *                     Map.entry("type", "Microsoft.Sql/Server/Database"),
 *                     Map.entry("user", "<user>")
 *                 )),
 *                 Map.entry("name", "outputtest")
 *             ))
 *             .resourceGroupName("sjrg3276")
 *             .sku(Map.of("name", "Standard"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key3", "value3"),
 *                 Map.entry("randomKey", "randomValue")
 *             ))
 *             .transformation(Map.ofEntries(
 *                 Map.entry("name", "transformationtest"),
 *                 Map.entry("query", "Select Id, Name from inputtest"),
 *                 Map.entry("streamingUnits", 1)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a streaming job shell (a streaming job with no inputs, outputs, transformation, or functions)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingJob = new AzureNative.StreamAnalytics.StreamingJob("streamingJob", new()
 *     {
 *         CompatibilityLevel = "1.0",
 *         DataLocale = "en-US",
 *         EventsLateArrivalMaxDelayInSeconds = 16,
 *         EventsOutOfOrderMaxDelayInSeconds = 5,
 *         EventsOutOfOrderPolicy = "Drop",
 *         Functions = new[] {},
 *         Inputs = new[] {},
 *         JobName = "sj59",
 *         Location = "West US",
 *         OutputErrorPolicy = "Drop",
 *         Outputs = new[] {},
 *         ResourceGroupName = "sjrg6936",
 *         Sku = new AzureNative.StreamAnalytics.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key3", "value3" },
 *             { "randomKey", "randomValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewStreamingJob(ctx, "streamingJob", &streamanalytics.StreamingJobArgs{
 * 			CompatibilityLevel:                 pulumi.String("1.0"),
 * 			DataLocale:                         pulumi.String("en-US"),
 * 			EventsLateArrivalMaxDelayInSeconds: pulumi.Int(16),
 * 			EventsOutOfOrderMaxDelayInSeconds:  pulumi.Int(5),
 * 			EventsOutOfOrderPolicy:             pulumi.String("Drop"),
 * 			Functions:                          streamanalytics.FunctionTypeArray{},
 * 			Inputs:                             streamanalytics.InputTypeArray{},
 * 			JobName:                            pulumi.String("sj59"),
 * 			Location:                           pulumi.String("West US"),
 * 			OutputErrorPolicy:                  pulumi.String("Drop"),
 * 			Outputs:                            streamanalytics.OutputTypeArray{},
 * 			ResourceGroupName:                  pulumi.String("sjrg6936"),
 * 			Sku: &streamanalytics.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1":      pulumi.String("value1"),
 * 				"key3":      pulumi.String("value3"),
 * 				"randomKey": pulumi.String("randomValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.StreamingJob;
 * import com.pulumi.azurenative.streamanalytics.StreamingJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingJob = new StreamingJob("streamingJob", StreamingJobArgs.builder()
 *             .compatibilityLevel("1.0")
 *             .dataLocale("en-US")
 *             .eventsLateArrivalMaxDelayInSeconds(16)
 *             .eventsOutOfOrderMaxDelayInSeconds(5)
 *             .eventsOutOfOrderPolicy("Drop")
 *             .functions()
 *             .inputs()
 *             .jobName("sj59")
 *             .location("West US")
 *             .outputErrorPolicy("Drop")
 *             .outputs()
 *             .resourceGroupName("sjrg6936")
 *             .sku(Map.of("name", "Standard"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key3", "value3"),
 *                 Map.entry("randomKey", "randomValue")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:StreamingJob sj59 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}
 * ```
 * @property cluster The cluster which streaming jobs will run on.
 * @property compatibilityLevel Controls certain runtime behaviors of the streaming job.
 * @property contentStoragePolicy Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
 * @property dataLocale The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
 * @property eventsLateArrivalMaxDelayInSeconds The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
 * @property eventsOutOfOrderMaxDelayInSeconds The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
 * @property eventsOutOfOrderPolicy Indicates the policy to apply to events that arrive out of order in the input event stream.
 * @property functions A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
 * @property identity Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
 * @property inputs A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
 * @property jobName The name of the streaming job.
 * @property jobStorageAccount The properties that are associated with an Azure Storage account with MSI
 * @property jobType Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
 * @property location The geo-location where the resource lives
 * @property outputErrorPolicy Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
 * @property outputStartMode This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
 * @property outputStartTime Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
 * @property outputs A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
 * @property tags Resource tags.
 * @property transformation Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
 */
public data class StreamingJobArgs(
    public val cluster: Output<ClusterInfoArgs>? = null,
    public val compatibilityLevel: Output<Either<String, CompatibilityLevel>>? = null,
    public val contentStoragePolicy: Output<Either<String, ContentStoragePolicy>>? = null,
    public val dataLocale: Output<String>? = null,
    public val eventsLateArrivalMaxDelayInSeconds: Output<Int>? = null,
    public val eventsOutOfOrderMaxDelayInSeconds: Output<Int>? = null,
    public val eventsOutOfOrderPolicy: Output<Either<String, EventsOutOfOrderPolicy>>? = null,
    public val functions: Output<List<FunctionArgs>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val inputs: Output<List<InputArgs>>? = null,
    public val jobName: Output<String>? = null,
    public val jobStorageAccount: Output<JobStorageAccountArgs>? = null,
    public val jobType: Output<Either<String, JobType>>? = null,
    public val location: Output<String>? = null,
    public val outputErrorPolicy: Output<Either<String, OutputErrorPolicy>>? = null,
    public val outputStartMode: Output<Either<String, OutputStartMode>>? = null,
    public val outputStartTime: Output<String>? = null,
    public val outputs: Output<List<OutputArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transformation: Output<TransformationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.StreamingJobArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.StreamingJobArgs =
        com.pulumi.azurenative.streamanalytics.StreamingJobArgs.builder()
            .cluster(cluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .compatibilityLevel(
                compatibilityLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .contentStoragePolicy(
                contentStoragePolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dataLocale(dataLocale?.applyValue({ args0 -> args0 }))
            .eventsLateArrivalMaxDelayInSeconds(
                eventsLateArrivalMaxDelayInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .eventsOutOfOrderMaxDelayInSeconds(
                eventsOutOfOrderMaxDelayInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .eventsOutOfOrderPolicy(
                eventsOutOfOrderPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .functions(
                functions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .jobStorageAccount(jobStorageAccount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobType(
                jobType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .outputErrorPolicy(
                outputErrorPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .outputStartMode(
                outputStartMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outputStartTime(outputStartTime?.applyValue({ args0 -> args0 }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transformation(
                transformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamingJobArgs].
 */
@PulumiTagMarker
public class StreamingJobArgsBuilder internal constructor() {
    private var cluster: Output<ClusterInfoArgs>? = null

    private var compatibilityLevel: Output<Either<String, CompatibilityLevel>>? = null

    private var contentStoragePolicy: Output<Either<String, ContentStoragePolicy>>? = null

    private var dataLocale: Output<String>? = null

    private var eventsLateArrivalMaxDelayInSeconds: Output<Int>? = null

    private var eventsOutOfOrderMaxDelayInSeconds: Output<Int>? = null

    private var eventsOutOfOrderPolicy: Output<Either<String, EventsOutOfOrderPolicy>>? = null

    private var functions: Output<List<FunctionArgs>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var inputs: Output<List<InputArgs>>? = null

    private var jobName: Output<String>? = null

    private var jobStorageAccount: Output<JobStorageAccountArgs>? = null

    private var jobType: Output<Either<String, JobType>>? = null

    private var location: Output<String>? = null

    private var outputErrorPolicy: Output<Either<String, OutputErrorPolicy>>? = null

    private var outputStartMode: Output<Either<String, OutputStartMode>>? = null

    private var outputStartTime: Output<String>? = null

    private var outputs: Output<List<OutputArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transformation: Output<TransformationArgs>? = null

    /**
     * @param value The cluster which streaming jobs will run on.
     */
    @JvmName("mtygqipyksobgtpv")
    public suspend fun cluster(`value`: Output<ClusterInfoArgs>) {
        this.cluster = value
    }

    /**
     * @param value Controls certain runtime behaviors of the streaming job.
     */
    @JvmName("klqidbagvftsifxk")
    public suspend fun compatibilityLevel(`value`: Output<Either<String, CompatibilityLevel>>) {
        this.compatibilityLevel = value
    }

    /**
     * @param value Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     */
    @JvmName("pyxhwmpbcwaanvhs")
    public suspend fun contentStoragePolicy(`value`: Output<Either<String, ContentStoragePolicy>>) {
        this.contentStoragePolicy = value
    }

    /**
     * @param value The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
     */
    @JvmName("goukcftjbrciuovp")
    public suspend fun dataLocale(`value`: Output<String>) {
        this.dataLocale = value
    }

    /**
     * @param value The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
     */
    @JvmName("xorjpuigfsocgcwp")
    public suspend fun eventsLateArrivalMaxDelayInSeconds(`value`: Output<Int>) {
        this.eventsLateArrivalMaxDelayInSeconds = value
    }

    /**
     * @param value The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
     */
    @JvmName("ilayijeodspvxkvn")
    public suspend fun eventsOutOfOrderMaxDelayInSeconds(`value`: Output<Int>) {
        this.eventsOutOfOrderMaxDelayInSeconds = value
    }

    /**
     * @param value Indicates the policy to apply to events that arrive out of order in the input event stream.
     */
    @JvmName("hnekmstngmqrkjsi")
    public suspend
    fun eventsOutOfOrderPolicy(`value`: Output<Either<String, EventsOutOfOrderPolicy>>) {
        this.eventsOutOfOrderPolicy = value
    }

    /**
     * @param value A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("nbikhrfbhpoyygvc")
    public suspend fun functions(`value`: Output<List<FunctionArgs>>) {
        this.functions = value
    }

    @JvmName("grjphtytchonlvqu")
    public suspend fun functions(vararg values: Output<FunctionArgs>) {
        this.functions = Output.all(values.asList())
    }

    /**
     * @param values A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("tpoetyougivolotw")
    public suspend fun functions(values: List<Output<FunctionArgs>>) {
        this.functions = Output.all(values)
    }

    /**
     * @param value Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
     */
    @JvmName("amixqfdgdtnbualw")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("fxlcyawntgijlqdm")
    public suspend fun inputs(`value`: Output<List<InputArgs>>) {
        this.inputs = value
    }

    @JvmName("dnswcmgnllccglcr")
    public suspend fun inputs(vararg values: Output<InputArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("fpsgiimivydlggsc")
    public suspend fun inputs(values: List<Output<InputArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("blspmxwgtyowotxb")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The properties that are associated with an Azure Storage account with MSI
     */
    @JvmName("yaxlldaftyldaijo")
    public suspend fun jobStorageAccount(`value`: Output<JobStorageAccountArgs>) {
        this.jobStorageAccount = value
    }

    /**
     * @param value Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
     */
    @JvmName("vcyxjxsncelfkfui")
    public suspend fun jobType(`value`: Output<Either<String, JobType>>) {
        this.jobType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("axstqxborwkfxkry")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
     */
    @JvmName("iidoqrgpahgrehvu")
    public suspend fun outputErrorPolicy(`value`: Output<Either<String, OutputErrorPolicy>>) {
        this.outputErrorPolicy = value
    }

    /**
     * @param value This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
     */
    @JvmName("cgiiyvepniyvldrv")
    public suspend fun outputStartMode(`value`: Output<Either<String, OutputStartMode>>) {
        this.outputStartMode = value
    }

    /**
     * @param value Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
     */
    @JvmName("qlrhvafejpuojivk")
    public suspend fun outputStartTime(`value`: Output<String>) {
        this.outputStartTime = value
    }

    /**
     * @param value A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("riuokdiltseedthp")
    public suspend fun outputs(`value`: Output<List<OutputArgs>>) {
        this.outputs = value
    }

    @JvmName("qiywbacwsuvqqnrq")
    public suspend fun outputs(vararg values: Output<OutputArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("snlleayselgsbdis")
    public suspend fun outputs(values: List<Output<OutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwynhpcsooyakcte")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("yaipwxvkdmolmkvk")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("srbacufkukvxsocy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("obrtltbsjdsmnevs")
    public suspend fun transformation(`value`: Output<TransformationArgs>) {
        this.transformation = value
    }

    /**
     * @param value The cluster which streaming jobs will run on.
     */
    @JvmName("ycfamhtxsbsnggep")
    public suspend fun cluster(`value`: ClusterInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param argument The cluster which streaming jobs will run on.
     */
    @JvmName("pfejdoecwxqdstek")
    public suspend fun cluster(argument: suspend ClusterInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cluster = mapped
    }

    /**
     * @param value Controls certain runtime behaviors of the streaming job.
     */
    @JvmName("kbwogmkbpftuxore")
    public suspend fun compatibilityLevel(`value`: Either<String, CompatibilityLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibilityLevel = mapped
    }

    /**
     * @param value Controls certain runtime behaviors of the streaming job.
     */
    @JvmName("ednrvbgfvdaefdhx")
    public fun compatibilityLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CompatibilityLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compatibilityLevel = mapped
    }

    /**
     * @param value Controls certain runtime behaviors of the streaming job.
     */
    @JvmName("irvhsjywpfafisjr")
    public fun compatibilityLevel(`value`: CompatibilityLevel) {
        val toBeMapped = Either.ofRight<String, CompatibilityLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compatibilityLevel = mapped
    }

    /**
     * @param value Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     */
    @JvmName("qjmposefuxeojhut")
    public suspend fun contentStoragePolicy(`value`: Either<String, ContentStoragePolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentStoragePolicy = mapped
    }

    /**
     * @param value Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     */
    @JvmName("meqgggsefqcklelv")
    public fun contentStoragePolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentStoragePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentStoragePolicy = mapped
    }

    /**
     * @param value Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     */
    @JvmName("anoegxaabpnjjamn")
    public fun contentStoragePolicy(`value`: ContentStoragePolicy) {
        val toBeMapped = Either.ofRight<String, ContentStoragePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentStoragePolicy = mapped
    }

    /**
     * @param value The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
     */
    @JvmName("stkbjasdokoecupl")
    public suspend fun dataLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLocale = mapped
    }

    /**
     * @param value The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
     */
    @JvmName("bdqsmuucodknwijd")
    public suspend fun eventsLateArrivalMaxDelayInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventsLateArrivalMaxDelayInSeconds = mapped
    }

    /**
     * @param value The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
     */
    @JvmName("skwxmjlvwmgtfoqo")
    public suspend fun eventsOutOfOrderMaxDelayInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventsOutOfOrderMaxDelayInSeconds = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive out of order in the input event stream.
     */
    @JvmName("vgdqgbacqsutlnde")
    public suspend fun eventsOutOfOrderPolicy(`value`: Either<String, EventsOutOfOrderPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventsOutOfOrderPolicy = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive out of order in the input event stream.
     */
    @JvmName("pauiufnihbqqwqyf")
    public fun eventsOutOfOrderPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventsOutOfOrderPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventsOutOfOrderPolicy = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive out of order in the input event stream.
     */
    @JvmName("ltxdqodaomqwbcpr")
    public fun eventsOutOfOrderPolicy(`value`: EventsOutOfOrderPolicy) {
        val toBeMapped = Either.ofRight<String, EventsOutOfOrderPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventsOutOfOrderPolicy = mapped
    }

    /**
     * @param value A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("gbcjiufxfctbceiq")
    public suspend fun functions(`value`: List<FunctionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    /**
     * @param argument A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("hhlxylqfekobvwcq")
    public suspend fun functions(argument: List<suspend FunctionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { FunctionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param argument A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("hhfsoxcmswsatnsd")
    public suspend fun functions(vararg argument: suspend FunctionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { FunctionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param argument A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("qpmagmoqopayqwlc")
    public suspend fun functions(argument: suspend FunctionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FunctionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param values A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("fbkclvlcjwcxfcca")
    public suspend fun functions(vararg values: FunctionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    /**
     * @param value Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
     */
    @JvmName("igsflqtorhyliqjf")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
     */
    @JvmName("dnyjeqxovgrwcxqk")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("kdnarsribiavgegl")
    public suspend fun inputs(`value`: List<InputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("hcvygjchqgmrtlqt")
    public suspend fun inputs(argument: List<suspend InputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { InputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("wnyaxfwuqyoxrprm")
    public suspend fun inputs(vararg argument: suspend InputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { InputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("xwrjwmrhqwmawejy")
    public suspend fun inputs(argument: suspend InputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    @JvmName("taqwellkkgrilbjb")
    public suspend fun inputs(vararg values: InputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("edqtvyopyacgujsq")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The properties that are associated with an Azure Storage account with MSI
     */
    @JvmName("plfglynyvpmdbhar")
    public suspend fun jobStorageAccount(`value`: JobStorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobStorageAccount = mapped
    }

    /**
     * @param argument The properties that are associated with an Azure Storage account with MSI
     */
    @JvmName("tkwdlvxubjrogjuc")
    public suspend fun jobStorageAccount(argument: suspend JobStorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = JobStorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jobStorageAccount = mapped
    }

    /**
     * @param value Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
     */
    @JvmName("dmieeowtaijvwsut")
    public suspend fun jobType(`value`: Either<String, JobType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
     */
    @JvmName("jowlytwndxolqfiw")
    public fun jobType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
     */
    @JvmName("cyllvqkdxerncixg")
    public fun jobType(`value`: JobType) {
        val toBeMapped = Either.ofRight<String, JobType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yrkusvcnvnqlownc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
     */
    @JvmName("saxwacxrhliouumk")
    public suspend fun outputErrorPolicy(`value`: Either<String, OutputErrorPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputErrorPolicy = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
     */
    @JvmName("nnybnmblvpsquhpo")
    public fun outputErrorPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputErrorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputErrorPolicy = mapped
    }

    /**
     * @param value Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
     */
    @JvmName("cxkeqccxgacqhefg")
    public fun outputErrorPolicy(`value`: OutputErrorPolicy) {
        val toBeMapped = Either.ofRight<String, OutputErrorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputErrorPolicy = mapped
    }

    /**
     * @param value This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
     */
    @JvmName("mqaeouwvlfnblaau")
    public suspend fun outputStartMode(`value`: Either<String, OutputStartMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputStartMode = mapped
    }

    /**
     * @param value This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
     */
    @JvmName("axuycbfsjbvgjtwj")
    public fun outputStartMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputStartMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputStartMode = mapped
    }

    /**
     * @param value This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
     */
    @JvmName("xdowxmwnwwmrscdt")
    public fun outputStartMode(`value`: OutputStartMode) {
        val toBeMapped = Either.ofRight<String, OutputStartMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputStartMode = mapped
    }

    /**
     * @param value Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
     */
    @JvmName("coboxiijrddgcwwq")
    public suspend fun outputStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputStartTime = mapped
    }

    /**
     * @param value A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("mputfwibswrdcuwd")
    public suspend fun outputs(`value`: List<OutputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("ivwhslsbggooewbt")
    public suspend fun outputs(argument: List<suspend OutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { OutputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("ygilyodtfgtsujnr")
    public suspend fun outputs(vararg argument: suspend OutputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { OutputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("uemksnnckitbbyub")
    public suspend fun outputs(argument: suspend OutputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OutputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    @JvmName("mkblyarhfnyodjaw")
    public suspend fun outputs(vararg values: OutputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vjveerehbxtlacvj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ocrbpokdyuifepvu")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("uravlalepdljnqiy")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("twubyramwrdvdpbs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qajnuvkawgcaoxtw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("yqeryttjccibnoww")
    public suspend fun transformation(`value`: TransformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformation = mapped
    }

    /**
     * @param argument Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    @JvmName("hbhuxgsuwutfmedl")
    public suspend fun transformation(argument: suspend TransformationArgsBuilder.() -> Unit) {
        val toBeMapped = TransformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transformation = mapped
    }

    internal fun build(): StreamingJobArgs = StreamingJobArgs(
        cluster = cluster,
        compatibilityLevel = compatibilityLevel,
        contentStoragePolicy = contentStoragePolicy,
        dataLocale = dataLocale,
        eventsLateArrivalMaxDelayInSeconds = eventsLateArrivalMaxDelayInSeconds,
        eventsOutOfOrderMaxDelayInSeconds = eventsOutOfOrderMaxDelayInSeconds,
        eventsOutOfOrderPolicy = eventsOutOfOrderPolicy,
        functions = functions,
        identity = identity,
        inputs = inputs,
        jobName = jobName,
        jobStorageAccount = jobStorageAccount,
        jobType = jobType,
        location = location,
        outputErrorPolicy = outputErrorPolicy,
        outputStartMode = outputStartMode,
        outputStartTime = outputStartTime,
        outputs = outputs,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        transformation = transformation,
    )
}
