@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
 */
public enum class JobType(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.JobType,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.JobType> {
    Cloud(com.pulumi.azurenative.streamanalytics.enums.JobType.Cloud),
    Edge(com.pulumi.azurenative.streamanalytics.enums.JobType.Edge),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.JobType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.JobType): JobType =
            JobType.values().first { it.javaValue == javaType }
    }
}
