@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
 */
public enum class OutputStartMode(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.OutputStartMode,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.OutputStartMode> {
    JobStartTime(com.pulumi.azurenative.streamanalytics.enums.OutputStartMode.JobStartTime),
    CustomTime(com.pulumi.azurenative.streamanalytics.enums.OutputStartMode.CustomTime),
    LastOutputEventTime(com.pulumi.azurenative.streamanalytics.enums.OutputStartMode.LastOutputEventTime),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.OutputStartMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.OutputStartMode):
            OutputStartMode = OutputStartMode.values().first { it.javaValue == javaType }
    }
}
