@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an input column for the Azure Machine Learning web service endpoint.
 * @property dataType The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
 * @property mapTo The zero based index of the function parameter this input maps to.
 * @property name The name of the input column.
 */
public data class AzureMachineLearningWebServiceInputColumnArgs(
    public val dataType: Output<String>? = null,
    public val mapTo: Output<Int>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputColumnArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputColumnArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputColumnArgs.builder()
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .mapTo(mapTo?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMachineLearningWebServiceInputColumnArgs].
 */
@PulumiTagMarker
public class AzureMachineLearningWebServiceInputColumnArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var mapTo: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
     */
    @JvmName("meljccvpflafrpbw")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value The zero based index of the function parameter this input maps to.
     */
    @JvmName("vbvliyyokjgtnuyy")
    public suspend fun mapTo(`value`: Output<Int>) {
        this.mapTo = value
    }

    /**
     * @param value The name of the input column.
     */
    @JvmName("qkmaxxoqfqqqpsbe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
     */
    @JvmName("ektllamlhudjkbgb")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The zero based index of the function parameter this input maps to.
     */
    @JvmName("obgjylbqgrpucuws")
    public suspend fun mapTo(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapTo = mapped
    }

    /**
     * @param value The name of the input column.
     */
    @JvmName("piihxmyjycmffmav")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureMachineLearningWebServiceInputColumnArgs =
        AzureMachineLearningWebServiceInputColumnArgs(
            dataType = dataType,
            mapTo = mapTo,
            name = name,
        )
}
