@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureSynapseOutputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an Azure Synapse output data source.
 * @property database The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property password The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property server The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Sql/Server/DataWarehouse'.
 * @property user The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 */
public data class AzureSynapseOutputDataSourceArgs(
    public val database: Output<String>? = null,
    public val password: Output<String>? = null,
    public val server: Output<String>? = null,
    public val table: Output<String>? = null,
    public val type: Output<String>,
    public val user: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureSynapseOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureSynapseOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureSynapseOutputDataSourceArgs.builder()
            .database(database?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSynapseOutputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureSynapseOutputDataSourceArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var table: Output<String>? = null

    private var type: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("rdqmhyywtyvnbjwa")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("plrdpbtwfhtdmqek")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("vhhvlxjuxsmysqex")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kofgrdcxryqevjhe")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/DataWarehouse'.
     */
    @JvmName("fxsmtxuerupjmyci")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("aqolybxhikkjwpfv")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ipqffsodelwbkroj")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("hupquyleqdskwnqd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("tajgxmnboojnkaak")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qammcofifmteutoo")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/DataWarehouse'.
     */
    @JvmName("tuosxmcufylvscoq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("rslvvhmavoojsgsj")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): AzureSynapseOutputDataSourceArgs = AzureSynapseOutputDataSourceArgs(
        database = database,
        password = password,
        server = server,
        table = table,
        type = type ?: throw PulumiNullFieldException("type"),
        user = user,
    )
}
