@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.EventHubStreamInputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an Event Hub input data source that contains stream data.
 * @property authenticationMode Authentication Mode.
 * @property consumerGroupName The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
 * @property eventHubName The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/EventHub'.
 */
public data class EventHubStreamInputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val consumerGroupName: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val sharedAccessPolicyKey: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.EventHubStreamInputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.EventHubStreamInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.EventHubStreamInputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .consumerGroupName(consumerGroupName?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyKey(sharedAccessPolicyKey?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubStreamInputDataSourceArgs].
 */
@PulumiTagMarker
public class EventHubStreamInputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var consumerGroupName: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var sharedAccessPolicyKey: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("eldaqppkwryajoah")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
     */
    @JvmName("mjfrffeqdgfwnjii")
    public suspend fun consumerGroupName(`value`: Output<String>) {
        this.consumerGroupName = value
    }

    /**
     * @param value The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ehegnlgwoclpuerc")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("erddfnxgccjokhvp")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("mnwqvqfnluhvintt")
    public suspend fun sharedAccessPolicyKey(`value`: Output<String>) {
        this.sharedAccessPolicyKey = value
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("hlfjunursfpsbmdc")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/EventHub'.
     */
    @JvmName("kxssbgicgfivgmuo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("fetgdlqvopdopwab")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("nwthyooompsuwhks")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("shgaynwjgknipjtv")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
     */
    @JvmName("mtwcycnltfciukpg")
    public suspend fun consumerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupName = mapped
    }

    /**
     * @param value The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("vcdjhwrndgcjgvwp")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("eybhlbdmgmkmplsd")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ajixpcjnndkkjoxb")
    public suspend fun sharedAccessPolicyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyKey = mapped
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qawxdamougtohtms")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/EventHub'.
     */
    @JvmName("koaahxkdbxcwxifb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventHubStreamInputDataSourceArgs = EventHubStreamInputDataSourceArgs(
        authenticationMode = authenticationMode,
        consumerGroupName = consumerGroupName,
        eventHubName = eventHubName,
        serviceBusNamespace = serviceBusNamespace,
        sharedAccessPolicyKey = sharedAccessPolicyKey,
        sharedAccessPolicyName = sharedAccessPolicyName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
