@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.FileReferenceInputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a file input data source that contains reference data.
 * @property path The path of the file.
 * @property type Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'File'.
 */
public data class FileReferenceInputDataSourceArgs(
    public val path: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.FileReferenceInputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.FileReferenceInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.FileReferenceInputDataSourceArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileReferenceInputDataSourceArgs].
 */
@PulumiTagMarker
public class FileReferenceInputDataSourceArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The path of the file.
     */
    @JvmName("yypbryguawvurcxe")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'File'.
     */
    @JvmName("tcmyoikabxamvkww")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The path of the file.
     */
    @JvmName("vfplfpfeglnomqdh")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'File'.
     */
    @JvmName("wofvmsdossmrsyhi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FileReferenceInputDataSourceArgs = FileReferenceInputDataSourceArgs(
        path = path,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
