@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.FunctionInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes one input parameter of a function.
 * @property dataType The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
 * @property isConfigurationParameter A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
 */
public data class FunctionInputArgs(
    public val dataType: Output<String>? = null,
    public val isConfigurationParameter: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.FunctionInputArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.FunctionInputArgs =
        com.pulumi.azurenative.streamanalytics.inputs.FunctionInputArgs.builder()
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .isConfigurationParameter(isConfigurationParameter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionInputArgs].
 */
@PulumiTagMarker
public class FunctionInputArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var isConfigurationParameter: Output<Boolean>? = null

    /**
     * @param value The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
     */
    @JvmName("iyonxwwwucxutjex")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
     */
    @JvmName("dmohwpscejxhnxih")
    public suspend fun isConfigurationParameter(`value`: Output<Boolean>) {
        this.isConfigurationParameter = value
    }

    /**
     * @param value The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
     */
    @JvmName("eeojfkkwioqudqrf")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
     */
    @JvmName("yidbvckyifxarthq")
    public suspend fun isConfigurationParameter(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isConfigurationParameter = mapped
    }

    internal fun build(): FunctionInputArgs = FunctionInputArgs(
        dataType = dataType,
        isConfigurationParameter = isConfigurationParameter,
    )
}
