@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.FunctionOutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the output of a function.
 * @property dataType The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
 */
public data class FunctionOutputArgs(
    public val dataType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.FunctionOutputArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.FunctionOutputArgs =
        com.pulumi.azurenative.streamanalytics.inputs.FunctionOutputArgs.builder()
            .dataType(dataType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionOutputArgs].
 */
@PulumiTagMarker
public class FunctionOutputArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    /**
     * @param value The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
     */
    @JvmName("jjcqrttpvtkjacxl")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
     */
    @JvmName("ucccysmkmapxvlpa")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    internal fun build(): FunctionOutputArgs = FunctionOutputArgs(
        dataType = dataType,
    )
}
