@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusOutputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a Gateway Message Bus output data source.
 * @property topic The name of the Service Bus topic.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'GatewayMessageBus'.
 */
public data class GatewayMessageBusOutputDataSourceArgs(
    public val topic: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusOutputDataSourceArgs.builder()
            .topic(topic?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayMessageBusOutputDataSourceArgs].
 */
@PulumiTagMarker
public class GatewayMessageBusOutputDataSourceArgsBuilder internal constructor() {
    private var topic: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the Service Bus topic.
     */
    @JvmName("nlhpjxiyuvrskquk")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'GatewayMessageBus'.
     */
    @JvmName("gfeujwiwstbdqdcm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Service Bus topic.
     */
    @JvmName("eltqthlkjsorkevq")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'GatewayMessageBus'.
     */
    @JvmName("elwfohhufuavmqhg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GatewayMessageBusOutputDataSourceArgs =
        GatewayMessageBusOutputDataSourceArgs(
            topic = topic,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
