@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GetOutputPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName The name of the streaming job.
 * @property outputName The name of the output.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetOutputPlainArgs(
    public val jobName: String,
    public val outputName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GetOutputPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.GetOutputPlainArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GetOutputPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .outputName(outputName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOutputPlainArgs].
 */
@PulumiTagMarker
public class GetOutputPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var outputName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("sovhxjlpenjojfal")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the output.
     */
    @JvmName("rooximrwxsforjhw")
    public suspend fun outputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.outputName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xfxlnjlxjvlodnry")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOutputPlainArgs = GetOutputPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        outputName = outputName ?: throw PulumiNullFieldException("outputName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
