@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.IdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how identity is verified
 * @property type The identity type
 */
public data class IdentityArgs(
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.IdentityArgs =
        com.pulumi.azurenative.streamanalytics.inputs.IdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The identity type
     */
    @JvmName("ecoyneobeylufewr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The identity type
     */
    @JvmName("dltkdnjdsyitfvyy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
    )
}
