@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.PrivateLinkServiceConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A grouping of information about the connection to the remote resource.
 * @property groupIds The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
 * @property privateLinkServiceId The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
 */
public data class PrivateLinkServiceConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateLinkServiceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.PrivateLinkServiceConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.PrivateLinkServiceConnectionArgs =
        com.pulumi.azurenative.streamanalytics.inputs.PrivateLinkServiceConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateLinkServiceId(privateLinkServiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateLinkServiceId: Output<String>? = null

    /**
     * @param value The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("ooeapjovigrlrtto")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("etmvnlicovrpgamv")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("abmdtropgrumogbb")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("ixkirxtgjyavbohe")
    public suspend fun privateLinkServiceId(`value`: Output<String>) {
        this.privateLinkServiceId = value
    }

    /**
     * @param value The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("mjimpngwlfsdugqi")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("avbvxgiconuanafd")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("qceywxrdsrxrsarf")
    public suspend fun privateLinkServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceId = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionArgs = PrivateLinkServiceConnectionArgs(
        groupIds = groupIds,
        privateLinkServiceId = privateLinkServiceId,
    )
}
