@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ReferenceInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties that are associated with an input containing reference data.
 * @property compression Describes how input data is compressed
 * @property datasource Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
 * @property partitionKey partitionKey Describes a key in the input data which is used for partitioning the input data
 * @property serialization Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Reference'.
 */
public data class ReferenceInputPropertiesArgs(
    public val compression: Output<CompressionArgs>? = null,
    public val datasource: Output<Any>? = null,
    public val partitionKey: Output<String>? = null,
    public val serialization: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ReferenceInputPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.ReferenceInputPropertiesArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ReferenceInputPropertiesArgs.builder()
            .compression(compression?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datasource(datasource?.applyValue({ args0 -> args0 }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .serialization(serialization?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReferenceInputPropertiesArgs].
 */
@PulumiTagMarker
public class ReferenceInputPropertiesArgsBuilder internal constructor() {
    private var compression: Output<CompressionArgs>? = null

    private var datasource: Output<Any>? = null

    private var partitionKey: Output<String>? = null

    private var serialization: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Describes how input data is compressed
     */
    @JvmName("eawdjdbdvajiuxfl")
    public suspend fun compression(`value`: Output<CompressionArgs>) {
        this.compression = value
    }

    /**
     * @param value Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ydgebxndgldvcfhs")
    public suspend fun datasource(`value`: Output<Any>) {
        this.datasource = value
    }

    /**
     * @param value partitionKey Describes a key in the input data which is used for partitioning the input data
     */
    @JvmName("vipnrdyaeikkwqty")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("itrdgymfaqrrkmpv")
    public suspend fun serialization(`value`: Output<Any>) {
        this.serialization = value
    }

    /**
     * @param value Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Reference'.
     */
    @JvmName("xeckcbrvwitutipq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Describes how input data is compressed
     */
    @JvmName("wlnqfcfkaoylmjev")
    public suspend fun compression(`value`: CompressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param argument Describes how input data is compressed
     */
    @JvmName("tunnsiamruxolofq")
    public suspend fun compression(argument: suspend CompressionArgsBuilder.() -> Unit) {
        val toBeMapped = CompressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compression = mapped
    }

    /**
     * @param value Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("dsnmequisuhrjfua")
    public suspend fun datasource(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasource = mapped
    }

    /**
     * @param value partitionKey Describes a key in the input data which is used for partitioning the input data
     */
    @JvmName("xmvjviaearglvpjx")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("uuonvwknotjobxlm")
    public suspend fun serialization(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialization = mapped
    }

    /**
     * @param value Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Reference'.
     */
    @JvmName("pnllxyeyjkjmftar")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReferenceInputPropertiesArgs = ReferenceInputPropertiesArgs(
        compression = compression,
        datasource = datasource,
        partitionKey = partitionKey,
        serialization = serialization,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
