@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ServiceBusQueueOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a Service Bus Queue output data source.
 * @property authenticationMode Authentication Mode.
 * @property propertyColumns A string array of the names of output columns to be attached to Service Bus messages as custom properties.
 * @property queueName The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property systemPropertyColumns The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/Queue'.
 */
public data class ServiceBusQueueOutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val propertyColumns: Output<List<String>>? = null,
    public val queueName: Output<String>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val sharedAccessPolicyKey: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val systemPropertyColumns: Output<Any>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ServiceBusQueueOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.ServiceBusQueueOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ServiceBusQueueOutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .propertyColumns(propertyColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyKey(sharedAccessPolicyKey?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .systemPropertyColumns(systemPropertyColumns?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceBusQueueOutputDataSourceArgs].
 */
@PulumiTagMarker
public class ServiceBusQueueOutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var propertyColumns: Output<List<String>>? = null

    private var queueName: Output<String>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var sharedAccessPolicyKey: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var systemPropertyColumns: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("knwtsdhavrgtpvcq")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("avimkiubrwltyptq")
    public suspend fun propertyColumns(`value`: Output<List<String>>) {
        this.propertyColumns = value
    }

    @JvmName("ihtgdxnupadbbkur")
    public suspend fun propertyColumns(vararg values: Output<String>) {
        this.propertyColumns = Output.all(values.asList())
    }

    /**
     * @param values A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("rbsknsnnpxdukuty")
    public suspend fun propertyColumns(values: List<Output<String>>) {
        this.propertyColumns = Output.all(values)
    }

    /**
     * @param value The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("chkunkxvnsdtxyeh")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("eiarsilooqoapvth")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("foflienkthawcbcp")
    public suspend fun sharedAccessPolicyKey(`value`: Output<String>) {
        this.sharedAccessPolicyKey = value
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("riccsjiobdufnhmu")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
     */
    @JvmName("veukusxecmddcwny")
    public suspend fun systemPropertyColumns(`value`: Output<Any>) {
        this.systemPropertyColumns = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/Queue'.
     */
    @JvmName("odvaquxgppndmrgl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("jpgnlfepjroxvvfo")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("mmsbhxdnphnnguxn")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("mqdqlnyamokpfkuw")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("xekuualhwaattrnx")
    public suspend fun propertyColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param values A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("xpcwqeakbpitwvjc")
    public suspend fun propertyColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param value The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qgtynvyxwpntxbam")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("uxayprmoacinnesm")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qwfokjdqmurvwngs")
    public suspend fun sharedAccessPolicyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyKey = mapped
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("tvkjxgaxowcgkkyj")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
     */
    @JvmName("fvlgnnebjygiuwvv")
    public suspend fun systemPropertyColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPropertyColumns = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/Queue'.
     */
    @JvmName("adcxalllvqkjypkq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceBusQueueOutputDataSourceArgs = ServiceBusQueueOutputDataSourceArgs(
        authenticationMode = authenticationMode,
        propertyColumns = propertyColumns,
        queueName = queueName,
        serviceBusNamespace = serviceBusNamespace,
        sharedAccessPolicyKey = sharedAccessPolicyKey,
        sharedAccessPolicyName = sharedAccessPolicyName,
        systemPropertyColumns = systemPropertyColumns,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
