@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A streaming job object, containing all information associated with the named streaming job.
 * @property cluster The cluster which streaming jobs will run on.
 * @property compatibilityLevel Controls certain runtime behaviors of the streaming job.
 * @property contentStoragePolicy Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
 * @property createdDate Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
 * @property dataLocale The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
 * @property etag The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property eventsLateArrivalMaxDelayInSeconds The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
 * @property eventsOutOfOrderMaxDelayInSeconds The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
 * @property eventsOutOfOrderPolicy Indicates the policy to apply to events that arrive out of order in the input event stream.
 * @property functions A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
 * @property inputs A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
 * @property jobId A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
 * @property jobState Describes the state of the streaming job.
 * @property jobStorageAccount The properties that are associated with an Azure Storage account with MSI
 * @property jobType Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
 * @property lastOutputEventTime Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or null indicating that output has not yet been produced. In case of multiple outputs or multiple streams, this shows the latest value in that set.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property outputErrorPolicy Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
 * @property outputStartMode This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
 * @property outputStartTime Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
 * @property outputs A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
 * @property provisioningState Describes the provisioning status of the streaming job.
 * @property sku Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
 * @property tags Resource tags.
 * @property transformation Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetStreamingJobResult(
    public val cluster: ClusterInfoResponse? = null,
    public val compatibilityLevel: String? = null,
    public val contentStoragePolicy: String? = null,
    public val createdDate: String,
    public val dataLocale: String? = null,
    public val etag: String,
    public val eventsLateArrivalMaxDelayInSeconds: Int? = null,
    public val eventsOutOfOrderMaxDelayInSeconds: Int? = null,
    public val eventsOutOfOrderPolicy: String? = null,
    public val functions: List<FunctionResponse>? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val inputs: List<InputResponse>? = null,
    public val jobId: String,
    public val jobState: String,
    public val jobStorageAccount: JobStorageAccountResponse? = null,
    public val jobType: String? = null,
    public val lastOutputEventTime: String,
    public val location: String? = null,
    public val name: String,
    public val outputErrorPolicy: String? = null,
    public val outputStartMode: String? = null,
    public val outputStartTime: String? = null,
    public val outputs: List<OutputResponse>? = null,
    public val provisioningState: String,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val transformation: TransformationResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.GetStreamingJobResult):
            GetStreamingJobResult = GetStreamingJobResult(
            cluster = javaType.cluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.ClusterInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            compatibilityLevel = javaType.compatibilityLevel().map({ args0 -> args0 }).orElse(null),
            contentStoragePolicy = javaType.contentStoragePolicy().map({ args0 -> args0 }).orElse(null),
            createdDate = javaType.createdDate(),
            dataLocale = javaType.dataLocale().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            eventsLateArrivalMaxDelayInSeconds = javaType.eventsLateArrivalMaxDelayInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            eventsOutOfOrderMaxDelayInSeconds = javaType.eventsOutOfOrderMaxDelayInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            eventsOutOfOrderPolicy = javaType.eventsOutOfOrderPolicy().map({ args0 -> args0 }).orElse(null),
            functions = javaType.functions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.FunctionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.InputResponse.Companion.toKotlin(args0)
                })
            }),
            jobId = javaType.jobId(),
            jobState = javaType.jobState(),
            jobStorageAccount = javaType.jobStorageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.JobStorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jobType = javaType.jobType().map({ args0 -> args0 }).orElse(null),
            lastOutputEventTime = javaType.lastOutputEventTime(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outputErrorPolicy = javaType.outputErrorPolicy().map({ args0 -> args0 }).orElse(null),
            outputStartMode = javaType.outputStartMode().map({ args0 -> args0 }).orElse(null),
            outputStartTime = javaType.outputStartTime().map({ args0 -> args0 }).orElse(null),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.OutputResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transformation = javaType.transformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.TransformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
