@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
 * @property id Resource Id
 * @property name Resource name
 * @property properties The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
 * @property type Resource type
 */
public data class InputResponse(
    public val id: String,
    public val name: String? = null,
    public val properties: Either<ReferenceInputPropertiesResponse, StreamInputPropertiesResponse>? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.InputResponse):
            InputResponse = InputResponse(
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.streamanalytics.kotlin.outputs.ReferenceInputPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.streamanalytics.kotlin.outputs.StreamInputPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
