@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.
 * @property etag The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property id Resource Id
 * @property name Resource name
 * @property query Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
 * @property streamingUnits Specifies the number of streaming units that the streaming job uses.
 * @property type Resource type
 * @property validStreamingUnits Specifies the valid streaming units a streaming job can scale to.
 */
public data class TransformationResponse(
    public val etag: String,
    public val id: String,
    public val name: String? = null,
    public val query: String? = null,
    public val streamingUnits: Int? = null,
    public val type: String,
    public val validStreamingUnits: List<Int>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.TransformationResponse):
            TransformationResponse = TransformationResponse(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            streamingUnits = javaType.streamingUnits().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            validStreamingUnits = javaType.validStreamingUnits().map({ args0 -> args0 }),
        )
    }
}
