@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.inputs

import com.pulumi.azurenative.subscription.inputs.PutAliasRequestAdditionalPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Put subscription additional properties.
 * @property managementGroupId Management group Id for the subscription.
 * @property subscriptionOwnerId Owner Id of the subscription
 * @property subscriptionTenantId Tenant Id of the subscription
 * @property tags Tags for the subscription
 */
public data class PutAliasRequestAdditionalPropertiesArgs(
    public val managementGroupId: Output<String>? = null,
    public val subscriptionOwnerId: Output<String>? = null,
    public val subscriptionTenantId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.subscription.inputs.PutAliasRequestAdditionalPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.subscription.inputs.PutAliasRequestAdditionalPropertiesArgs =
        com.pulumi.azurenative.subscription.inputs.PutAliasRequestAdditionalPropertiesArgs.builder()
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .subscriptionOwnerId(subscriptionOwnerId?.applyValue({ args0 -> args0 }))
            .subscriptionTenantId(subscriptionTenantId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PutAliasRequestAdditionalPropertiesArgs].
 */
@PulumiTagMarker
public class PutAliasRequestAdditionalPropertiesArgsBuilder internal constructor() {
    private var managementGroupId: Output<String>? = null

    private var subscriptionOwnerId: Output<String>? = null

    private var subscriptionTenantId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Management group Id for the subscription.
     */
    @JvmName("njrswmpmkxjweinv")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value Owner Id of the subscription
     */
    @JvmName("ihmbfxwtfsoojatv")
    public suspend fun subscriptionOwnerId(`value`: Output<String>) {
        this.subscriptionOwnerId = value
    }

    /**
     * @param value Tenant Id of the subscription
     */
    @JvmName("edmsxubtvrkssiew")
    public suspend fun subscriptionTenantId(`value`: Output<String>) {
        this.subscriptionTenantId = value
    }

    /**
     * @param value Tags for the subscription
     */
    @JvmName("junjlhggmksmgiqb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Management group Id for the subscription.
     */
    @JvmName("qaavibmfbolekkgh")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value Owner Id of the subscription
     */
    @JvmName("uoqeewjjxyqdkyjd")
    public suspend fun subscriptionOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionOwnerId = mapped
    }

    /**
     * @param value Tenant Id of the subscription
     */
    @JvmName("mgpmenlrodgqjctf")
    public suspend fun subscriptionTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionTenantId = mapped
    }

    /**
     * @param value Tags for the subscription
     */
    @JvmName("poyaldtqjfbvhjkh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags for the subscription
     */
    @JvmName("cycjwgqpusjioevj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PutAliasRequestAdditionalPropertiesArgs =
        PutAliasRequestAdditionalPropertiesArgs(
            managementGroupId = managementGroupId,
            subscriptionOwnerId = subscriptionOwnerId,
            subscriptionTenantId = subscriptionTenantId,
            tags = tags,
        )
}
