@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.IntegrationRuntimeArgs.builder
import com.pulumi.azurenative.synapse.kotlin.inputs.ManagedIntegrationRuntimeArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.SelfHostedIntegrationRuntimeArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Integration runtime resource type.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create integration runtime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationRuntime = new AzureNative.Synapse.IntegrationRuntime("integrationRuntime", new()
 *     {
 *         IntegrationRuntimeName = "exampleIntegrationRuntime",
 *         Properties = new AzureNative.Synapse.Inputs.SelfHostedIntegrationRuntimeArgs
 *         {
 *             Description = "A selfhosted integration runtime",
 *             Type = "SelfHosted",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         WorkspaceName = "exampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewIntegrationRuntime(ctx, "integrationRuntime", &synapse.IntegrationRuntimeArgs{
 * 			IntegrationRuntimeName: pulumi.String("exampleIntegrationRuntime"),
 * 			Properties: synapse.SelfHostedIntegrationRuntime{
 * 				Description: "A selfhosted integration runtime",
 * 				Type:        "SelfHosted",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			WorkspaceName:     pulumi.String("exampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.IntegrationRuntime;
 * import com.pulumi.azurenative.synapse.IntegrationRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationRuntime = new IntegrationRuntime("integrationRuntime", IntegrationRuntimeArgs.builder()
 *             .integrationRuntimeName("exampleIntegrationRuntime")
 *             .properties(Map.ofEntries(
 *                 Map.entry("description", "A selfhosted integration runtime"),
 *                 Map.entry("type", "SelfHosted")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .workspaceName("exampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:IntegrationRuntime exampleIntegrationRuntime /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/integrationRuntimes/{integrationRuntimeName}
 * ```
 * @property integrationRuntimeName Integration runtime name
 * @property properties Integration runtime properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class IntegrationRuntimeArgs(
    public val integrationRuntimeName: Output<String>? = null,
    public val properties:
    Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.IntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.IntegrationRuntimeArgs =
        com.pulumi.azurenative.synapse.IntegrationRuntimeArgs.builder()
            .integrationRuntimeName(integrationRuntimeName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeArgsBuilder internal constructor() {
    private var integrationRuntimeName: Output<String>? = null

    private var properties:
        Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Integration runtime name
     */
    @JvmName("gxliatmhirmxusku")
    public suspend fun integrationRuntimeName(`value`: Output<String>) {
        this.integrationRuntimeName = value
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("qhpahwocxlxjyded")
    public suspend
    fun properties(`value`: Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("watxsmbxmmictxbs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("vorkcwmgbgbgtkdj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Integration runtime name
     */
    @JvmName("symdabraybknbfhe")
    public suspend fun integrationRuntimeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("votvjahwapfpqpjq")
    public suspend
    fun properties(`value`: Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("sxnflpahpgbqdowa")
    public fun properties(`value`: ManagedIntegrationRuntimeArgs) {
        val toBeMapped = Either.ofLeft<ManagedIntegrationRuntimeArgs,
            SelfHostedIntegrationRuntimeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("mpccirkkvrflswxk")
    public fun properties(`value`: SelfHostedIntegrationRuntimeArgs) {
        val toBeMapped = Either.ofRight<ManagedIntegrationRuntimeArgs,
            SelfHostedIntegrationRuntimeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yqtuleisaabepmqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mdapxmsvtkmvietm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IntegrationRuntimeArgs = IntegrationRuntimeArgs(
        integrationRuntimeName = integrationRuntimeName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
