@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.AzureSkuResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.LanguageExtensionsListResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.OptimizedAutoscaleResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.synapse.kotlin.outputs.AzureSkuResponse.Companion.toKotlin as azureSkuResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.LanguageExtensionsListResponse.Companion.toKotlin as languageExtensionsListResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.OptimizedAutoscaleResponse.Companion.toKotlin as optimizedAutoscaleResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KustoPool].
 */
@PulumiTagMarker
public class KustoPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KustoPoolArgs = KustoPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KustoPoolArgsBuilder.() -> Unit) {
        val builder = KustoPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KustoPool {
        val builtJavaResource = com.pulumi.azurenative.synapse.KustoPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KustoPool(builtJavaResource)
    }
}

/**
 * Class representing a Kusto kusto pool.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### kustoPoolsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPool = new AzureNative.Synapse.KustoPool("kustoPool", new()
 *     {
 *         EnablePurge = true,
 *         EnableStreamingIngest = true,
 *         KustoPoolName = "kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         Sku = new AzureNative.Synapse.Inputs.AzureSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Storage optimized",
 *             Size = "Medium",
 *         },
 *         WorkspaceName = "synapseWorkspaceName",
 *         WorkspaceUID = "11111111-2222-3333-444444444444",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPool(ctx, "kustoPool", &synapse.KustoPoolArgs{
 * 			EnablePurge:           pulumi.Bool(true),
 * 			EnableStreamingIngest: pulumi.Bool(true),
 * 			KustoPoolName:         pulumi.String("kustoclusterrptest4"),
 * 			Location:              pulumi.String("westus"),
 * 			ResourceGroupName:     pulumi.String("kustorptest"),
 * 			Sku: &synapse.AzureSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Storage optimized"),
 * 				Size:     pulumi.String("Medium"),
 * 			},
 * 			WorkspaceName: pulumi.String("synapseWorkspaceName"),
 * 			WorkspaceUID:  pulumi.String("11111111-2222-3333-444444444444"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPool;
 * import com.pulumi.azurenative.synapse.KustoPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPool = new KustoPool("kustoPool", KustoPoolArgs.builder()
 *             .enablePurge(true)
 *             .enableStreamingIngest(true)
 *             .kustoPoolName("kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Storage optimized"),
 *                 Map.entry("size", "Medium")
 *             ))
 *             .workspaceName("synapseWorkspaceName")
 *             .workspaceUID("11111111-2222-3333-444444444444")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPool KustoClusterRPTest4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}
 * ```
 */
public class KustoPool internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.KustoPool,
) : KotlinCustomResource(javaResource, KustoPoolMapper) {
    /**
     * The Kusto Pool data ingestion URI.
     */
    public val dataIngestionUri: Output<String>
        get() = javaResource.dataIngestionUri().applyValue({ args0 -> args0 })

    /**
     * A boolean value that indicates if the purge operations are enabled.
     */
    public val enablePurge: Output<Boolean>?
        get() = javaResource.enablePurge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates if the streaming ingest is enabled.
     */
    public val enableStreamingIngest: Output<Boolean>?
        get() = javaResource.enableStreamingIngest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of the Kusto Pool's language extensions.
     */
    public val languageExtensions: Output<LanguageExtensionsListResponse>
        get() = javaResource.languageExtensions().applyValue({ args0 ->
            args0.let({ args0 ->
                languageExtensionsListResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Optimized auto scale definition.
     */
    public val optimizedAutoscale: Output<OptimizedAutoscaleResponse>?
        get() = javaResource.optimizedAutoscale().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> optimizedAutoscaleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU of the kusto pool.
     */
    public val sku: Output<AzureSkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                azureSkuResponseToKotlin(args0)
            })
        })

    /**
     * The state of the resource.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The reason for the Kusto Pool's current state.
     */
    public val stateReason: Output<String>
        get() = javaResource.stateReason().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Kusto Pool URI.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })

    /**
     * The workspace unique identifier.
     */
    public val workspaceUID: Output<String>?
        get() = javaResource.workspaceUID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object KustoPoolMapper : ResourceMapper<KustoPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.KustoPool::class == javaResource::class

    override fun map(javaResource: Resource): KustoPool = KustoPool(
        javaResource as
            com.pulumi.azurenative.synapse.KustoPool,
    )
}

/**
 * @see [KustoPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KustoPool].
 */
public suspend fun kustoPool(name: String, block: suspend KustoPoolResourceBuilder.() -> Unit):
    KustoPool {
    val builder = KustoPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KustoPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kustoPool(name: String): KustoPool {
    val builder = KustoPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
