@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.PrivateLinkHubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A privateLinkHub
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a privateLinkHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkHub = new AzureNative.Synapse.PrivateLinkHub("privateLinkHub", new()
 *     {
 *         Location = "East US",
 *         PrivateLinkHubName = "privateLinkHub1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewPrivateLinkHub(ctx, "privateLinkHub", &synapse.PrivateLinkHubArgs{
 * 			Location:           pulumi.String("East US"),
 * 			PrivateLinkHubName: pulumi.String("privateLinkHub1"),
 * 			ResourceGroupName:  pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.PrivateLinkHub;
 * import com.pulumi.azurenative.synapse.PrivateLinkHubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkHub = new PrivateLinkHub("privateLinkHub", PrivateLinkHubArgs.builder()
 *             .location("East US")
 *             .privateLinkHubName("privateLinkHub1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:PrivateLinkHub privateLinkHub1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}
 * ```
 * @property location The geo-location where the resource lives
 * @property privateLinkHubName Name of the privateLinkHub
 * @property provisioningState PrivateLinkHub provisioning state
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class PrivateLinkHubArgs(
    public val location: Output<String>? = null,
    public val privateLinkHubName: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.PrivateLinkHubArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.PrivateLinkHubArgs =
        com.pulumi.azurenative.synapse.PrivateLinkHubArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .privateLinkHubName(privateLinkHubName?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkHubArgs].
 */
@PulumiTagMarker
public class PrivateLinkHubArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var privateLinkHubName: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("caopujmsdleixnid")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the privateLinkHub
     */
    @JvmName("vqoghnwqqfcmeopt")
    public suspend fun privateLinkHubName(`value`: Output<String>) {
        this.privateLinkHubName = value
    }

    /**
     * @param value PrivateLinkHub provisioning state
     */
    @JvmName("mmdgjgxjqowfcurp")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mbdfqnnjugxovitt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("okvybymieijnlnhv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jdukbhfneuavuhib")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the privateLinkHub
     */
    @JvmName("gyxuuamivuaqyike")
    public suspend fun privateLinkHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkHubName = mapped
    }

    /**
     * @param value PrivateLinkHub provisioning state
     */
    @JvmName("lwrmgbpffkufesvs")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tgpyusjnqhgddoxa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qcvefvyutmdahumy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jdfhqpdqhcixfmjp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkHubArgs = PrivateLinkHubArgs(
        location = location,
        privateLinkHubName = privateLinkHubName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
