@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.DatabaseStatisticsResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.synapse.kotlin.outputs.DatabaseStatisticsResponse.Companion.toKotlin as databaseStatisticsResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ReadWriteDatabase].
 */
@PulumiTagMarker
public class ReadWriteDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReadWriteDatabaseArgs = ReadWriteDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReadWriteDatabaseArgsBuilder.() -> Unit) {
        val builder = ReadWriteDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReadWriteDatabase {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.ReadWriteDatabase(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReadWriteDatabase(builtJavaResource)
    }
}

/**
 * Class representing a read write database.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readWriteDatabase = new AzureNative.Synapse.ReadWriteDatabase("readWriteDatabase", new()
 *     {
 *         DatabaseName = "KustoDatabase8",
 *         Kind = "ReadWrite",
 *         KustoPoolName = "kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         SoftDeletePeriod = "P1D",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewReadWriteDatabase(ctx, "readWriteDatabase", &synapse.ReadWriteDatabaseArgs{
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			Kind:              pulumi.String("ReadWrite"),
 * 			KustoPoolName:     pulumi.String("kustoclusterrptest4"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			SoftDeletePeriod:  pulumi.String("P1D"),
 * 			WorkspaceName:     pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.ReadWriteDatabase;
 * import com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readWriteDatabase = new ReadWriteDatabase("readWriteDatabase", ReadWriteDatabaseArgs.builder()
 *             .databaseName("KustoDatabase8")
 *             .kind("ReadWrite")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .softDeletePeriod("P1D")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:ReadWriteDatabase KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}
 * ```
 */
public class ReadWriteDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.ReadWriteDatabase,
) : KotlinCustomResource(javaResource, ReadWriteDatabaseMapper) {
    /**
     * The time the data should be kept in cache for fast queries in TimeSpan.
     */
    public val hotCachePeriod: Output<String>?
        get() = javaResource.hotCachePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the database is followed.
     */
    public val isFollowed: Output<Boolean>
        get() = javaResource.isFollowed().applyValue({ args0 -> args0 })

    /**
     * Kind of the database
     * Expected value is 'ReadWrite'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    public val softDeletePeriod: Output<String>?
        get() = javaResource.softDeletePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The statistics of the database.
     */
    public val statistics: Output<DatabaseStatisticsResponse>
        get() = javaResource.statistics().applyValue({ args0 ->
            args0.let({ args0 ->
                databaseStatisticsResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReadWriteDatabaseMapper : ResourceMapper<ReadWriteDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.ReadWriteDatabase::class == javaResource::class

    override fun map(javaResource: Resource): ReadWriteDatabase = ReadWriteDatabase(
        javaResource as
            com.pulumi.azurenative.synapse.ReadWriteDatabase,
    )
}

/**
 * @see [ReadWriteDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReadWriteDatabase].
 */
public suspend fun readWriteDatabase(
    name: String,
    block: suspend ReadWriteDatabaseResourceBuilder.() -> Unit,
): ReadWriteDatabase {
    val builder = ReadWriteDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReadWriteDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun readWriteDatabase(name: String): ReadWriteDatabase {
    val builder = ReadWriteDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
